/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class InspectNetworkCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void inspectNetwork() throws DockerException {
        List networks = (List)this.dockerClient.listNetworksCmd().exec();
        Network expected = this.findNetwork(networks, "bridge");
        Network network = this.dockerClient.inspectNetworkCmd().withNetworkId(expected.getId()).exec();
        MatcherAssert.assertThat((Object)network.getName(), (Matcher)Matchers.equalTo((Object)expected.getName()));
        MatcherAssert.assertThat((Object)network.getScope(), (Matcher)Matchers.equalTo((Object)expected.getScope()));
        MatcherAssert.assertThat((Object)network.getDriver(), (Matcher)Matchers.equalTo((Object)expected.getDriver()));
        MatcherAssert.assertThat((Object)((Network.Ipam.Config)network.getIpam().getConfig().get(0)).getSubnet(), (Matcher)Matchers.equalTo((Object)((Network.Ipam.Config)expected.getIpam().getConfig().get(0)).getSubnet()));
        MatcherAssert.assertThat((Object)network.getIpam().getDriver(), (Matcher)Matchers.equalTo((Object)expected.getIpam().getDriver()));
    }
}

