/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class LogContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void asyncLogContainerWithTtyEnabled() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"/bin/sh", "-c", "while true; do echo hello; sleep 1; done"}).withTty(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        AbstractDockerClientTest.LogContainerTestCallback loggingCallback = new AbstractDockerClientTest.LogContainerTestCallback(true);
        this.dockerClient.logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withTailAll().exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion(3L, TimeUnit.SECONDS);
        LogContainerCmdExecTest.assertTrue((boolean)loggingCallback.toString().contains("hello"));
        LogContainerCmdExecTest.assertEquals((Object)loggingCallback.getCollectedFrames().get(0).getStreamType(), (Object)StreamType.RAW);
    }

    @Test
    public void asyncLogContainerWithTtyDisabled() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"/bin/sh", "-c", "while true; do echo hello; sleep 1; done"}).withTty(Boolean.valueOf(false)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        AbstractDockerClientTest.LogContainerTestCallback loggingCallback = new AbstractDockerClientTest.LogContainerTestCallback(true);
        this.dockerClient.logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withTailAll().exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion(3L, TimeUnit.SECONDS);
        LogContainerCmdExecTest.assertTrue((boolean)loggingCallback.toString().contains("hello"));
        LogContainerCmdExecTest.assertEquals((Object)loggingCallback.getCollectedFrames().get(0).getStreamType(), (Object)StreamType.STDOUT);
    }

    @Test
    public void asyncLogNonExistingContainer() throws Exception {
        AbstractDockerClientTest.LogContainerTestCallback loggingCallback = new AbstractDockerClientTest.LogContainerTestCallback(){

            public void onError(Throwable throwable) {
                Assert.assertEquals((String)throwable.getClass().getName(), (String)NotFoundException.class.getName());
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
                super.onError(throwable);
            }

            public void onComplete() {
                super.onComplete();
                Assert.fail((String)"expected NotFoundException");
            }
        };
        ((AbstractDockerClientTest.LogContainerTestCallback)this.dockerClient.logContainerCmd("non-existing").withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback)).awaitCompletion();
    }

    @Test
    public void asyncMultipleLogContainer() throws Exception {
        String snippet = "hello world";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"/bin/echo", snippet}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        int exitCode = ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        AbstractDockerClientTest.LogContainerTestCallback loggingCallback = new AbstractDockerClientTest.LogContainerTestCallback();
        this.dockerClient.logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback);
        loggingCallback.close();
        loggingCallback = new AbstractDockerClientTest.LogContainerTestCallback();
        this.dockerClient.logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback);
        loggingCallback.close();
        loggingCallback = new AbstractDockerClientTest.LogContainerTestCallback();
        this.dockerClient.logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion();
        LogContainerCmdExecTest.assertTrue((boolean)loggingCallback.toString().contains(snippet));
    }

    @Test
    public void asyncLogContainerWithSince() throws Exception {
        String snippet = "hello world";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"/bin/echo", snippet}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        this.dockerClient.startContainerCmd(container.getId()).exec();
        int exitCode = ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        AbstractDockerClientTest.LogContainerTestCallback loggingCallback = new AbstractDockerClientTest.LogContainerTestCallback();
        this.dockerClient.logContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withSince(Integer.valueOf(timestamp)).exec((ResultCallback)loggingCallback);
        loggingCallback.awaitCompletion();
        MatcherAssert.assertThat((Object)loggingCallback.toString(), (Matcher)Matchers.containsString((String)snippet));
    }
}

