/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.github.dockerjava.utils.TestUtils;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class StopContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(StopContainerCmdExecTest.class);

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void testStopContainer() throws DockerException {
        RemoteApiVersion apiVersion = TestUtils.getVersion(this.dockerClient);
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        LOG.info("Stopping container: {}", (Object)container.getId());
        this.dockerClient.stopContainerCmd(container.getId()).withTimeout(Integer.valueOf(2)).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        Integer exitCode = inspectContainerResponse.getState().getExitCode();
        if (apiVersion.equals((Object)RemoteApiVersion.VERSION_1_22)) {
            MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.is((Object)0));
        } else {
            MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.not((Object)0));
        }
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void testStopNonExistingContainer() throws DockerException {
        this.dockerClient.stopContainerCmd("non-existing").withTimeout(Integer.valueOf(2)).exec();
    }
}

