/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.handler;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.netty.handler.HttpResponseStreamHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpResponseStreamHandlerTest {
    @Test
    public void testNoBytesSkipped() throws Exception {
        ResultCallbackTest callback = new ResultCallbackTest();
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler((ResultCallback)callback);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        ByteBuf buffer = this.generateByteBuf();
        streamHandler.channelRead0(ctx, buffer);
        streamHandler.channelReadComplete(ctx);
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)callback.getInputStream(), (InputStream)new ByteBufInputStream(buffer)));
    }

    private ByteBuf generateByteBuf() {
        byte[] array = new byte[256];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)i;
        }
        return Unpooled.copiedBuffer((byte[])array);
    }

    private static class ResultCallbackTest
    extends ResultCallbackTemplate<ResultCallbackTest, InputStream> {
        private InputStream stream;

        private ResultCallbackTest() {
        }

        public void onNext(InputStream stream) {
            this.stream = stream;
        }

        public InputStream getInputStream() {
            return this.stream;
        }
    }
}

