/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class ContainerUtils {
    private ContainerUtils() {
    }

    public static void startContainer(DockerClient dockerClient, CreateContainerResponse container) {
        dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)true));
    }

    public static void pauseContainer(DockerClient dockerClient, CreateContainerResponse container) {
        dockerClient.pauseContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getPaused(), (Matcher)Matchers.is((Object)true));
    }

    public static void stopContainer(DockerClient dockerClient, CreateContainerResponse container) {
        dockerClient.stopContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)false));
    }

    public static void unpauseContainer(DockerClient dockerClient, CreateContainerResponse container) {
        dockerClient.unpauseContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getPaused(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)true));
    }
}

