/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api;

import com.github.dockerjava.api.model.Binds;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.object.IsCompatibleType;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class ModelsSerializableTest {
    private static final Logger LOG = LoggerFactory.getLogger(ModelsSerializableTest.class);
    private List<String> excludeClasses = Arrays.asList(Binds.class.getName(), BuildResponseItem.class.getName(), PullResponseItem.class.getName(), PushResponseItem.class.getName(), ResponseItem.class.getName());

    @Test
    public void allModelsSerializable() throws IOException, NoSuchFieldException, IllegalAccessException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (ClassPath.ClassInfo classInfo : ClassPath.from((ClassLoader)contextClassLoader).getTopLevelClasses("com.github.dockerjava.api.model")) {
            Class aClass;
            if (classInfo.getName().endsWith("Test") || (aClass = classInfo.load()).getProtectionDomain().getCodeSource().getLocation().getPath().endsWith("test-classes/") || aClass.isEnum()) continue;
            LOG.debug("aClass: {}", (Object)aClass);
            Assert.assertThat((Object)aClass, (Matcher)IsCompatibleType.typeCompatibleWith(Serializable.class));
            Object serialVersionUID = FieldUtils.readDeclaredStaticField((Class)aClass, (String)"serialVersionUID", (boolean)true);
            if (this.excludeClasses.contains(aClass.getName())) continue;
            Assert.assertThat((Object)serialVersionUID, (Matcher)Matchers.instanceOf(Long.class));
            Assert.assertThat((String)"Follow devel docs", (Object)((Long)serialVersionUID), (Matcher)Matchers.is((Object)1L));
        }
    }
}

