/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.command.CommandJSONSamples;
import com.github.dockerjava.api.command.HealthStateLog;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InspectContainerResponseTest {
    @Test
    public void roundTrip_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full, InspectContainerResponse[].class);
        Assert.assertEquals((int)1, (int)responses.length);
        InspectContainerResponse response = responses[0];
        Assert.assertEquals((int)response.getVolumes().length, (int)2);
        Assert.assertEquals((int)response.getVolumesRW().length, (int)2);
        Assert.assertEquals((String)response.getVolumes()[1].getContainerPath(), (String)"/bar/foo/myvol2");
        Assert.assertEquals((String)response.getVolumes()[1].getHostPath(), (String)"/path2");
        Assert.assertEquals((String)response.getVolumesRW()[1].getVolume().getPath(), (String)"/bar/foo/myvol2");
        Assert.assertFalse((boolean)response.getVolumesRW()[1].getAccessMode().toBoolean());
        Assert.assertTrue((boolean)response.getVolumesRW()[0].getAccessMode().toBoolean());
        MatcherAssert.assertThat((Object)response.getLogPath(), (Matcher)Matchers.is((Object)"/mnt/sda1/var/lib/docker/containers/469e5edd8d5b33e3c905a7ffc97360ec6ee211d6782815fbcd144568045819e1/469e5edd8d5b33e3c905a7ffc97360ec6ee211d6782815fbcd144568045819e1-json.log"));
    }

    @Test
    public void roundTrip_full_healthcheck() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().uncheckedSimpleType(InspectContainerResponse.class);
        InspectContainerResponse response = (InspectContainerResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_24, "/containers/inspect/1.json", type);
        Assert.assertEquals((String)response.getState().getHealth().getStatus(), (String)"healthy");
        Assert.assertEquals((Object)response.getState().getHealth().getFailingStreak(), (Object)new Integer(0));
        Assert.assertEquals((int)response.getState().getHealth().getLog().size(), (int)2);
        Assert.assertEquals((String)((HealthStateLog)response.getState().getHealth().getLog().get(0)).getOutput(), (String)"Hello");
        Assert.assertEquals((String)((HealthStateLog)response.getState().getHealth().getLog().get(1)).getOutput(), (String)"World");
    }

    @Test
    public void roundTrip_1_21_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full_1_21, InspectContainerResponse[].class);
        Assert.assertEquals((int)1, (int)responses.length);
        InspectContainerResponse response = responses[0];
        InspectContainerResponse.ContainerState state = response.getState();
        MatcherAssert.assertThat((Object)state, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
        Assert.assertFalse((boolean)state.getDead());
        MatcherAssert.assertThat((Object)state.getStatus(), (Matcher)Matchers.containsString((String)"running"));
        Assert.assertFalse((boolean)state.getRestarting());
        Assert.assertFalse((boolean)state.getOOMKilled());
        MatcherAssert.assertThat((Object)state.getError(), (Matcher)Matchers.isEmptyString());
    }

    @Test
    public void roundTrip_empty() throws IOException {
        JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_empty, InspectContainerResponse[].class);
    }
}

