/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthConfigTest {
    @Test
    public void defaultServerAddress() throws Exception {
        Assert.assertEquals((String)new AuthConfig().getRegistryAddress(), (String)"https://index.docker.io/v1/");
    }

    @Test
    public void serderDocs1() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().uncheckedSimpleType(AuthConfig.class);
        AuthConfig authConfig = (AuthConfig)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/other/AuthConfig/docs1.json", type);
        MatcherAssert.assertThat((Object)authConfig, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authConfig.getUsername(), (Matcher)CoreMatchers.is((Object)"jdoe"));
        MatcherAssert.assertThat((Object)authConfig.getPassword(), (Matcher)CoreMatchers.is((Object)"secret"));
        MatcherAssert.assertThat((Object)authConfig.getEmail(), (Matcher)CoreMatchers.is((Object)"jdoe@acme.com"));
        AuthConfig authConfig1 = new AuthConfig().withUsername("jdoe").withPassword("secret").withEmail("jdoe@acme.com");
        MatcherAssert.assertThat((Object)authConfig1, (Matcher)CoreMatchers.equalTo((Object)authConfig));
    }

    @Test
    public void serderDocs2() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().uncheckedSimpleType(AuthConfig.class);
        AuthConfig authConfig = (AuthConfig)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/other/AuthConfig/docs2.json", type);
        MatcherAssert.assertThat((Object)authConfig, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authConfig.getRegistrytoken(), (Matcher)CoreMatchers.is((Object)"9cbaf023786cd7..."));
        AuthConfig authConfig1 = new AuthConfig().withRegistrytoken("9cbaf023786cd7...");
        MatcherAssert.assertThat((Object)authConfig1, (Matcher)CoreMatchers.equalTo((Object)authConfig));
    }
}

