/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.PropagationMode;
import com.github.dockerjava.api.model.SELContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.testng.annotations.Test;

public class BindTest {
    @Test
    public void parseUsingDefaultAccessMode() {
        Bind bind = Bind.parse((String)"/host:/container");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWrite() {
        Bind bind = Bind.parse((String)"/host:/container:rw");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteNoCopy() {
        Bind bind = Bind.parse((String)"/host:/container:rw,nocopy");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteShared() {
        Bind bind = Bind.parse((String)"/host:/container:rw,shared");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.SHARED));
    }

    @Test
    public void parseReadWriteSlave() {
        Bind bind = Bind.parse((String)"/host:/container:rw,slave");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.SLAVE));
    }

    @Test
    public void parseReadWritePrivate() {
        Bind bind = Bind.parse((String)"/host:/container:rw,private");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.PRIVATE));
    }

    @Test
    public void parseReadOnly() {
        Bind bind = Bind.parse((String)"/host:/container:ro");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseSELOnly() {
        Bind bind = Bind.parse((String)"/host:/container:Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
        bind = Bind.parse((String)"/host:/container:z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteSEL() {
        Bind bind = Bind.parse((String)"/host:/container:rw,Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadOnlySEL() {
        Bind bind = Bind.parse((String)"/host:/container:ro,z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind.*")
    public void parseInvalidAccessMode() {
        Bind.parse((String)"/host:/container:xx");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind 'nonsense'")
    public void parseInvalidInput() {
        Bind.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind 'null'")
    public void parseNull() {
        Bind.parse(null);
    }

    @Test
    public void toStringReadOnly() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:ro").toString(), (Matcher)Is.is((Object)"/host:/container:ro"));
    }

    @Test
    public void toStringReadWrite() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw").toString(), (Matcher)Is.is((Object)"/host:/container:rw"));
    }

    @Test
    public void toStringReadWriteNoCopy() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,nocopy").toString(), (Matcher)Is.is((Object)"/host:/container:rw,nocopy"));
    }

    @Test
    public void toStringReadWriteShared() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,shared").toString(), (Matcher)Is.is((Object)"/host:/container:rw,shared"));
    }

    @Test
    public void toStringReadWriteSlave() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,slave").toString(), (Matcher)Is.is((Object)"/host:/container:rw,slave"));
    }

    @Test
    public void toStringReadWritePrivate() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,private").toString(), (Matcher)Is.is((Object)"/host:/container:rw,private"));
    }

    @Test
    public void toStringDefaultAccessMode() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container").toString(), (Matcher)Is.is((Object)"/host:/container:rw"));
    }

    @Test
    public void toStringReadOnlySEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:ro,Z").toString(), (Matcher)Is.is((Object)"/host:/container:ro,Z"));
    }

    @Test
    public void toStringReadWriteSEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,z").toString(), (Matcher)Is.is((Object)"/host:/container:rw,z"));
    }

    @Test
    public void toStringDefaultSEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:Z").toString(), (Matcher)Is.is((Object)"/host:/container:rw,Z"));
    }
}

