/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Identifier;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class IdentifierTest {
    @Test
    public void testFromCompoundString() throws Exception {
        Identifier i1 = Identifier.fromCompoundString((String)"10.0.0.1/jim");
        Identifier i2 = Identifier.fromCompoundString((String)"10.0.0.1/jim:123");
        Identifier i3 = Identifier.fromCompoundString((String)"10.0.0.1:123/jim:124");
        Identifier i3A = Identifier.fromCompoundString((String)"10.0.0.1:123/jim:latest");
        AssertJUnit.assertTrue((!i1.tag.isPresent() ? 1 : 0) != 0);
        Assert.assertEquals((String)i1.repository.name, (String)"10.0.0.1/jim");
        AssertJUnit.assertTrue((boolean)i2.tag.isPresent());
        Assert.assertEquals((String)((String)i2.tag.get()), (String)"123");
        Assert.assertEquals((String)i2.repository.name, (String)"10.0.0.1/jim");
        AssertJUnit.assertTrue((boolean)i3.tag.isPresent());
        Assert.assertEquals((String)((String)i3.tag.get()), (String)"124");
        Assert.assertEquals((String)i3.repository.name, (String)"10.0.0.1:123/jim");
        Assert.assertEquals((int)i3.repository.getURL().getPort(), (int)123);
        Assert.assertEquals((String)((String)i3A.tag.get()), (String)"latest");
        Identifier i4 = Identifier.fromCompoundString((String)"centos:latest");
        AssertJUnit.assertTrue((boolean)i4.tag.isPresent());
        Assert.assertEquals((String)((String)i4.tag.get()), (String)"latest");
        Identifier i5 = Identifier.fromCompoundString((String)"busybox");
        AssertJUnit.assertTrue((!i5.tag.isPresent() ? 1 : 0) != 0);
        Identifier i6 = Identifier.fromCompoundString((String)"10.0.0.1:5000/my-test-image:1234");
        Assert.assertEquals((String)i6.repository.getPath(), (String)"my-test-image");
    }
}

