/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PortBindingTest {
    private static final ExposedPort TCP_8080 = ExposedPort.tcp((int)8080);

    @Test
    public void fullDefinition() {
        Assert.assertEquals((Object)PortBinding.parse((String)"127.0.0.1:80:8080/tcp"), (Object)new PortBinding(Ports.Binding.bindIpAndPort((String)"127.0.0.1", (int)80), TCP_8080));
    }

    @Test
    public void noProtocol() {
        Assert.assertEquals((Object)PortBinding.parse((String)"127.0.0.1:80:8080"), (Object)new PortBinding(Ports.Binding.bindIpAndPort((String)"127.0.0.1", (int)80), TCP_8080));
    }

    @Test
    public void noHostIp() {
        Assert.assertEquals((Object)PortBinding.parse((String)"80:8080/tcp"), (Object)new PortBinding(Ports.Binding.bindPort((int)80), TCP_8080));
    }

    @Test
    public void portsOnly() {
        Assert.assertEquals((Object)PortBinding.parse((String)"80:8080"), (Object)new PortBinding(Ports.Binding.bindPort((int)80), TCP_8080));
    }

    @Test
    public void exposedPortOnly() {
        Assert.assertEquals((Object)PortBinding.parse((String)"8080"), (Object)new PortBinding(Ports.Binding.empty(), TCP_8080));
    }

    @Test
    public void dynamicHostPort() {
        Assert.assertEquals((Object)PortBinding.parse((String)"127.0.0.1::8080"), (Object)new PortBinding(Ports.Binding.bindIp((String)"127.0.0.1"), TCP_8080));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing PortBinding 'nonsense'", enabled=false)
    public void parseInvalidInput() {
        PortBinding.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing PortBinding 'null'")
    public void parseNull() {
        PortBinding.parse(null);
    }
}

