/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Ports_SerializingTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String jsonWithDoubleBindingForOnePort = "{\"80/tcp\":[{\"HostIp\":\"10.0.0.1\",\"HostPort\":\"80\"},{\"HostIp\":\"10.0.0.2\",\"HostPort\":\"80\"}]}";
    private final String jsonWithNullBindingForOnePort = "{\"80/tcp\":null}";

    @Test
    public void deserializingPortWithMultipleBindings() throws Exception {
        Ports ports = (Ports)this.objectMapper.readValue("{\"80/tcp\":[{\"HostIp\":\"10.0.0.1\",\"HostPort\":\"80\"},{\"HostIp\":\"10.0.0.2\",\"HostPort\":\"80\"}]}", Ports.class);
        Map map = ports.getBindings();
        Assert.assertEquals((int)map.size(), (int)1);
        Ports.Binding[] bindings = (Ports.Binding[])map.get(ExposedPort.tcp((int)80));
        Assert.assertEquals((int)bindings.length, (int)2);
        Assert.assertEquals((Object)bindings[0], (Object)new Ports.Binding("10.0.0.1", "80"));
        Assert.assertEquals((Object)bindings[1], (Object)new Ports.Binding("10.0.0.2", "80"));
    }

    @Test
    public void serializingPortWithMultipleBindings() throws Exception {
        Ports ports = new Ports();
        ports.bind(ExposedPort.tcp((int)80), new Ports.Binding("10.0.0.1", "80"));
        ports.bind(ExposedPort.tcp((int)80), new Ports.Binding("10.0.0.2", "80"));
        Assert.assertEquals((String)this.objectMapper.writeValueAsString((Object)ports), (String)"{\"80/tcp\":[{\"HostIp\":\"10.0.0.1\",\"HostPort\":\"80\"},{\"HostIp\":\"10.0.0.2\",\"HostPort\":\"80\"}]}");
    }

    @Test
    public void serializingEmptyBinding() throws Exception {
        Ports ports = new Ports(ExposedPort.tcp((int)80), new Ports.Binding(null, null));
        Assert.assertEquals((String)this.objectMapper.writeValueAsString((Object)ports), (String)"{\"80/tcp\":[{\"HostIp\":\"\",\"HostPort\":\"\"}]}");
    }

    @Test
    public void deserializingPortWithNullBindings() throws Exception {
        Ports ports = (Ports)this.objectMapper.readValue("{\"80/tcp\":null}", Ports.class);
        Map map = ports.getBindings();
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertEquals((Object[])((Object[])map.get(ExposedPort.tcp((int)80))), null);
    }

    @Test
    public void serializingWithNullBindings() throws Exception {
        Ports ports = new Ports();
        ports.bind(ExposedPort.tcp((int)80), null);
        Assert.assertEquals((String)this.objectMapper.writeValueAsString((Object)ports), (String)"{\"80/tcp\":null}");
    }
}

