/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class Ports_addBindingsTest {
    private static final ExposedPort TCP_80 = ExposedPort.tcp((int)80);
    private static final ExposedPort TCP_90 = ExposedPort.tcp((int)90);
    private static final Ports.Binding BINDING_8080 = Ports.Binding.bindPort((int)8080);
    private static final Ports.Binding BINDING_9090 = Ports.Binding.bindPort((int)9090);
    private Ports ports;

    @BeforeMethod
    public void setup() {
        this.ports = new Ports();
    }

    @Test
    public void addTwoBindingsForDifferentExposedPorts() {
        this.ports.add(new PortBinding[]{new PortBinding(BINDING_8080, TCP_80), new PortBinding(BINDING_9090, TCP_90)});
        Map bindings = this.ports.getBindings();
        Assert.assertEquals((int)bindings.size(), (int)2);
        Assert.assertEquals((Object[])((Object[])bindings.get(TCP_80)), (Object[])new Ports.Binding[]{BINDING_8080});
        Assert.assertEquals((Object[])((Object[])bindings.get(TCP_90)), (Object[])new Ports.Binding[]{BINDING_9090});
    }

    @Test
    public void addTwoBindingsForSameExposedPort() {
        this.ports.add(new PortBinding[]{new PortBinding(BINDING_8080, TCP_80), new PortBinding(BINDING_9090, TCP_80)});
        Map bindings = this.ports.getBindings();
        Assert.assertEquals((int)bindings.size(), (int)1);
        Assert.assertEquals((Object[])((Object[])bindings.get(TCP_80)), (Object[])new Ports.Binding[]{BINDING_8080, BINDING_9090});
    }

    @Test
    public void addNullBindings() {
        this.ports.add(new PortBinding[]{new PortBinding(null, TCP_80)});
        Map bindings = this.ports.getBindings();
        Assert.assertEquals((int)bindings.size(), (int)1);
        Assert.assertEquals((Object[])((Object[])bindings.get(TCP_80)), null);
    }
}

