/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.TestDockerCmdExecFactory;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITestResult;

public abstract class AbstractDockerClientTest
extends Assert {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractDockerClientTest.class);
    protected DockerClient dockerClient;
    protected TestDockerCmdExecFactory dockerCmdExecFactory = this.initTestDockerCmdExecFactory();

    protected TestDockerCmdExecFactory initTestDockerCmdExecFactory() {
        return new TestDockerCmdExecFactory(DockerClientBuilder.getDefaultDockerCmdExecFactory());
    }

    public void beforeTest() throws Exception {
        LOG.info("======================= BEFORETEST =======================");
        LOG.info("Connecting to Docker server");
        this.dockerClient = DockerClientBuilder.getInstance((DockerClientConfig)this.config()).withDockerCmdExecFactory((DockerCmdExecFactory)this.dockerCmdExecFactory).build();
        try {
            this.dockerClient.inspectImageCmd("busybox").exec();
        }
        catch (NotFoundException e) {
            LOG.info("Pulling image 'busybox'");
            ((PullImageResultCallback)this.dockerClient.pullImageCmd("busybox").withTag("latest").exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
        }
        AbstractDockerClientTest.assertNotNull((Object)this.dockerClient);
        LOG.info("======================= END OF BEFORETEST =======================\n\n");
    }

    private DefaultDockerClientConfig config() {
        return this.config(null);
    }

    protected DefaultDockerClientConfig config(String password) {
        DefaultDockerClientConfig.Builder builder = DefaultDockerClientConfig.createDefaultConfigBuilder().withRegistryUrl("https://index.docker.io/v1/");
        if (password != null) {
            builder = builder.withRegistryPassword(password);
        }
        return builder.build();
    }

    public void afterTest() {
        LOG.info("======================= END OF AFTERTEST =======================");
    }

    public void beforeMethod(Method method) {
        LOG.info(String.format("################################## STARTING %s ##################################", method.getName()));
    }

    public void afterMethod(ITestResult result) {
        for (String container : this.dockerCmdExecFactory.getContainerNames()) {
            LOG.info("Cleaning up temporary container {}", (Object)container);
            try {
                this.dockerClient.removeContainerCmd(container).withForce(Boolean.valueOf(true)).exec();
            }
            catch (DockerException dockerException) {}
        }
        for (String image : this.dockerCmdExecFactory.getImageNames()) {
            LOG.info("Cleaning up temporary image with {}", (Object)image);
            try {
                this.dockerClient.removeImageCmd(image).withForce(Boolean.valueOf(true)).exec();
            }
            catch (DockerException dockerException) {}
        }
        for (String volume : this.dockerCmdExecFactory.getVolumeNames()) {
            LOG.info("Cleaning up temporary volume with {}", (Object)volume);
            try {
                this.dockerClient.removeVolumeCmd(volume).exec();
            }
            catch (DockerException dockerException) {}
        }
        for (String networkId : this.dockerCmdExecFactory.getNetworkIds()) {
            LOG.info("Cleaning up temporary network with {}", (Object)networkId);
            try {
                this.dockerClient.removeNetworkCmd(networkId).exec();
            }
            catch (DockerException dockerException) {}
        }
        LOG.info("################################## END OF {} ##################################\n", (Object)result.getName());
    }

    protected String asString(InputStream response) {
        return AbstractDockerClientTest.consumeAsString(response);
    }

    public static String consumeAsString(InputStream response) {
        StringWriter logwriter = new StringWriter();
        try {
            LineIterator itr = IOUtils.lineIterator((InputStream)response, (String)"UTF-8");
            while (itr.hasNext()) {
                String line = itr.next();
                logwriter.write(line + (itr.hasNext() ? "\n" : ""));
                LOG.info("line: " + line);
            }
            response.close();
            String string = logwriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean available(int port) {
        if (port < 1100 || port > 60000) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            Boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    protected MountedVolumes mountedVolumes(Matcher<? super List<Volume>> subMatcher) {
        return new MountedVolumes(subMatcher, "Mounted volumes", "mountedVolumes");
    }

    protected String containerLog(String containerId) throws Exception {
        return ((LogContainerResultCallback)((LogContainerTestCallback)this.dockerClient.logContainerCmd(containerId).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)new LogContainerTestCallback())).awaitCompletion()).toString();
    }

    protected String buildImage(File baseDir) throws Exception {
        return ((BuildImageResultCallback)this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
    }

    protected Network findNetwork(List<Network> networks, String name) {
        for (Network network : networks) {
            if (!StringUtils.equals((String)network.getName(), (String)name)) continue;
            return network;
        }
        AbstractDockerClientTest.fail((String)"No network found.");
        return null;
    }

    public static class LogContainerTestCallback
    extends LogContainerResultCallback {
        protected final StringBuffer log = new StringBuffer();
        List<Frame> collectedFrames = new ArrayList<Frame>();
        boolean collectFrames = false;

        public LogContainerTestCallback() {
            this(false);
        }

        public LogContainerTestCallback(boolean collectFrames) {
            this.collectFrames = collectFrames;
        }

        public void onNext(Frame frame) {
            if (this.collectFrames) {
                this.collectedFrames.add(frame);
            }
            this.log.append(new String(frame.getPayload()));
        }

        public String toString() {
            return this.log.toString();
        }

        public List<Frame> getCollectedFrames() {
            return this.collectedFrames;
        }
    }

    private static class MountedVolumes
    extends FeatureMatcher<InspectContainerResponse, List<Volume>> {
        public MountedVolumes(Matcher<? super List<Volume>> subMatcher, String featureDescription, String featureName) {
            super(subMatcher, featureDescription, featureName);
        }

        public List<Volume> featureValueOf(InspectContainerResponse item) {
            ArrayList<Volume> volumes = new ArrayList<Volume>();
            for (InspectContainerResponse.Mount mount : item.getMounts()) {
                volumes.add(mount.getDestination());
            }
            return volumes;
        }
    }
}

