/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.AuthConfigFile;
import java.io.File;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthConfigFileTest {
    private final File FILESROOT = new File(Thread.currentThread().getContextClassLoader().getResource("testAuthConfigFile").getFile());

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="The Auth Config file is empty")
    public void emptyFile() throws IOException {
        this.runTest("emptyFile");
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="The Auth Config file is empty")
    public void tooSmallFile() throws IOException {
        this.runTest("tooSmallFile");
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="Invalid auth configuration file")
    public void invalidJsonInvalidAuth() throws IOException {
        this.runTest("invalidJsonInvalidAuth");
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="Invalid Auth config file")
    public void invalidLegacyAuthLine() throws IOException {
        this.runTest("invalidLegacyAuthLine");
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="Invalid auth configuration file")
    public void invalidLegacyInvalidAuth() throws IOException {
        this.runTest("invalidLegacyInvalidAuth");
    }

    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="Invalid Auth config file")
    public void invalidLegacyEmailLine() throws IOException {
        this.runTest("invalidLegacyEmailLine");
    }

    @Test
    public void validJson() throws IOException {
        AuthConfig authConfig1 = new AuthConfig().withEmail("foo@example.com").withUsername("foo").withPassword("bar").withRegistryAddress("quay.io");
        AuthConfig authConfig2 = new AuthConfig().withEmail("moo@example.com").withUsername("foo1").withPassword("bar1").withRegistryAddress("https://index.docker.io/v1/");
        AuthConfigFile expected = new AuthConfigFile();
        expected.addConfig(authConfig1);
        expected.addConfig(authConfig2);
        Assert.assertEquals((Object)this.runTest("validJson"), (Object)expected);
    }

    @Test
    public void validLegacy() throws IOException {
        AuthConfig authConfig = new AuthConfig().withEmail("foo@example.com").withUsername("foo").withPassword("bar").withRegistryAddress("https://index.docker.io/v1/");
        AuthConfigFile expected = new AuthConfigFile();
        expected.addConfig(authConfig);
        Assert.assertEquals((Object)this.runTest("validLegacy"), (Object)expected);
    }

    @Test
    public void nonExistent() throws IOException {
        AuthConfigFile expected = new AuthConfigFile();
        Assert.assertEquals((Object)this.runTest("idontexist"), (Object)expected);
    }

    private AuthConfigFile runTest(String testFileName) throws IOException {
        return AuthConfigFile.loadConfig((File)new File(this.FILESROOT, testFileName));
    }
}

