/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.core.util.CompressArchiveUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testng.annotations.Test;

public class CompressArchiveUtilTest {
    @Test
    public void testExecutableFlagIsPreserved() throws Exception {
        File executableFile = this.createExecutableFile();
        File archive = CompressArchiveUtil.archiveTARFiles((File)executableFile.getParentFile(), Arrays.asList(executableFile), (String)"archive");
        File expectedFile = this.extractFileByName(archive, "executableFile.sh.result");
        MatcherAssert.assertThat((String)"should be executable", (boolean)expectedFile.canExecute());
    }

    private File createExecutableFile() throws IOException {
        File baseDir = new File(FileUtils.getTempDirectoryPath());
        File executableFile = new File(baseDir, "executableFile.sh");
        executableFile.createNewFile();
        executableFile.setExecutable(true);
        MatcherAssert.assertThat((Object)executableFile.canExecute(), (Matcher)CoreMatchers.is((Object)true));
        return executableFile;
    }

    private File extractFileByName(File archive, String filenameToExtract) throws IOException {
        TarArchiveEntry entry;
        File baseDir = new File(FileUtils.getTempDirectoryPath());
        File expectedFile = new File(baseDir, filenameToExtract);
        expectedFile.delete();
        MatcherAssert.assertThat((Object)expectedFile.exists(), (Matcher)CoreMatchers.is((Object)false));
        TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(archive))));
        while ((entry = tarArchiveInputStream.getNextTarEntry()) != null) {
            String individualFiles = entry.getName();
            MatcherAssert.assertThat((Object)individualFiles, (Matcher)CoreMatchers.equalTo((Object)"executableFile.sh"));
            IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)new FileOutputStream(expectedFile));
            if ((entry.getMode() & 0x1ED) != 493) continue;
            expectedFile.setExecutable(true);
        }
        tarArchiveInputStream.close();
        return expectedFile;
    }
}

