/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DockerClientBuilderTest {
    private static final int AMOUNT = 100;

    @Test
    public void testConcurrentClientBuilding() throws Exception {
        final Set instances = Collections.synchronizedSet(new HashSet());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DockerCmdExecFactory factory = DockerClientBuilder.getDefaultDockerCmdExecFactory();
                Assert.assertNotNull((Object)factory);
                Assert.assertFalse((boolean)instances.contains(factory));
                instances.add(factory);
            }
        };
        DockerClientBuilderTest.parallel(100, runnable);
        Assert.assertEquals((int)instances.size(), (int)100);
    }

    public static void parallel(int threads, final Runnable task) throws Exception {
        final ExceptionListener exceptionListener = new ExceptionListener();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    exceptionListener.onException(e);
                }
            }
        };
        ArrayList<Thread> threadList = new ArrayList<Thread>(threads);
        for (int i = 0; i < threads; ++i) {
            Thread thread = new Thread(runnable);
            thread.start();
            threadList.add(thread);
        }
        for (Thread thread : threadList) {
            thread.join();
        }
        Throwable exception = exceptionListener.getException();
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    private static class ExceptionListener {
        private Throwable exception;

        private ExceptionListener() {
        }

        private synchronized void onException(Throwable e) {
            this.exception = e;
        }

        private synchronized Throwable getException() {
            return this.exception;
        }
    }
}

