/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.utils.TestUtils;
import java.lang.reflect.Method;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class AuthCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testAuth() throws Exception {
        RemoteApiVersion apiVersion = TestUtils.getVersion(this.dockerClient);
        if (!apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_23)) {
            throw new SkipException("Fails on 1.22. Temporary disabled.");
        }
        AuthResponse response = this.dockerClient.authCmd().exec();
        AuthCmdImplTest.assertEquals((String)response.getStatus(), (String)"Login Succeeded");
    }

    @Test(enabled=false, expectedExceptions={UnauthorizedException.class}, expectedExceptionsMessageRegExp="Wrong login/password, please try again")
    public void testAuthInvalid() throws Exception {
        DockerClientBuilder.getInstance((DockerClientConfig)this.config("garbage")).build().authCmd().exec();
    }
}

