/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class CopyArchiveToContainerCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void copyFileToContainer() throws Exception {
        CreateContainerResponse container = this.prepareContainerForCopy();
        Path temp = Files.createTempFile("", ".tar.gz", new FileAttribute[0]);
        CompressArchiveUtil.tar((Path)Paths.get("src/test/resources/testReadFile", new String[0]), (Path)temp, (boolean)true, (boolean)false);
        try (InputStream uploadStream = Files.newInputStream(temp, new OpenOption[0]);){
            this.dockerClient.copyArchiveToContainerCmd(container.getId()).withTarInputStream(uploadStream).exec();
            this.assertFileCopied(container);
        }
    }

    @Test
    public void copyStreamToContainer() throws Exception {
        CreateContainerResponse container = this.prepareContainerForCopy();
        this.dockerClient.copyArchiveToContainerCmd(container.getId()).withHostResource("src/test/resources/testReadFile").exec();
        this.assertFileCopied(container);
    }

    private CreateContainerResponse prepareContainerForCopy() {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("docker-java-itest-copyToContainer").exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        return container;
    }

    private void assertFileCopied(CreateContainerResponse container) throws IOException {
        try (InputStream response = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "testReadFile").exec();){
            boolean bytesAvailable = response.available() > 0;
            CopyArchiveToContainerCmdImplTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied to the container.");
        }
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void copyToNonExistingContainer() throws Exception {
        this.dockerClient.copyArchiveToContainerCmd("non-existing").withHostResource("src/test/resources/testReadFile").exec();
    }

    @Test
    public void copyDirWithLastAddedTarEntryEmptyDir() throws Exception {
        Path localDir = Files.createTempDirectory(null, new FileAttribute[0]);
        localDir.toFile().deleteOnExit();
        Files.createDirectory(localDir.resolve("b"), new FileAttribute[0]);
        Path dirWithFile = Files.createDirectory(localDir.resolve("a"), new FileAttribute[0]);
        Files.createFile(dirWithFile.resolve("file"), new FileAttribute[0]);
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.dockerClient.copyArchiveToContainerCmd(container.getId()).withHostResource(localDir.toString()).exec();
        FileUtils.deleteDirectory((File)localDir.toFile());
    }

    @Test
    public void copyFileWithExecutePermission() throws Exception {
        Path scriptPath = Files.createTempFile("run", ".sh", new FileAttribute[0]);
        boolean executable = scriptPath.toFile().setExecutable(true, false);
        if (!executable) {
            throw new Exception("Execute permission on file not set!");
        }
        String snippet = "Running script with execute permission.";
        String scriptTextStr = "#!/bin/sh\necho \"" + snippet + "\"";
        Files.write(scriptPath, scriptTextStr.getBytes(), new OpenOption[0]);
        String containerCmd = "sleep 3; /home/" + scriptPath.getFileName().toString();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("test").withCmd(new String[]{"/bin/sh", "-c", containerCmd}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.dockerClient.copyArchiveToContainerCmd(container.getId()).withRemotePath("/home").withHostResource(scriptPath.toString()).exec();
        int exitCode = ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
    }
}

