/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.InspectVolumeResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class InspectVolumeCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void inspectVolume() throws DockerException {
        String volumeName = "volume1";
        this.dockerClient.createVolumeCmd().withName(volumeName).withDriver("local").exec();
        InspectVolumeResponse inspectVolumeResponse = (InspectVolumeResponse)this.dockerClient.inspectVolumeCmd(volumeName).exec();
        MatcherAssert.assertThat((Object)inspectVolumeResponse.getName(), (Matcher)Matchers.equalTo((Object)"volume1"));
        MatcherAssert.assertThat((Object)inspectVolumeResponse.getDriver(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)inspectVolumeResponse.getMountpoint(), (Matcher)Matchers.containsString((String)"/volume1/"));
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void inspectNonExistentVolume() throws DockerException {
        String volumeName = "non-existing";
        this.dockerClient.inspectVolumeCmd(volumeName).exec();
    }
}

