/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class ListImagesCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void listImages() throws DockerException {
        List images = (List)this.dockerClient.listImagesCmd().withShowAll(Boolean.valueOf(true)).exec();
        MatcherAssert.assertThat((Object)images, (Matcher)Matchers.notNullValue());
        LOG.info("Images List: {}", (Object)images);
        Info info = (Info)this.dockerClient.infoCmd().exec();
        MatcherAssert.assertThat((Object)images.size(), (Matcher)Matchers.equalTo((Object)info.getImages()));
        Image img = (Image)images.get(0);
        MatcherAssert.assertThat((Object)img.getCreated(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getVirtualSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)img.getRepoTags(), (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
    }

    @Test(groups={"ignoreInCircleCi"})
    public void listImagesWithDanglingFilter() throws DockerException {
        String imageId = this.createDanglingImage();
        List images = (List)this.dockerClient.listImagesCmd().withDanglingFilter(Boolean.valueOf(true)).withShowAll(Boolean.valueOf(true)).exec();
        MatcherAssert.assertThat((Object)images, (Matcher)Matchers.notNullValue());
        LOG.info("Images List: {}", (Object)images);
        MatcherAssert.assertThat((Object)images.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Boolean imageInFilteredList = this.isImageInFilteredList(images, imageId);
        ListImagesCmdImplTest.assertTrue((boolean)imageInFilteredList);
    }

    private boolean isImageInFilteredList(List<Image> images, String expectedImageId) {
        for (Image image : images) {
            if (!expectedImageId.equals(image.getId())) continue;
            return true;
        }
        return false;
    }

    private String createDanglingImage() {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        LOG.info("Committing container {}", (Object)container.toString());
        String imageId = this.dockerClient.commitCmd(container.getId()).exec();
        this.dockerClient.stopContainerCmd(container.getId()).exec();
        this.dockerClient.removeContainerCmd(container.getId()).exec();
        return imageId;
    }
}

