/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.utils.TestResources;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class LoadImageCmdImplTest
extends AbstractDockerClientTest {
    private String expectedImageId;

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
        this.expectedImageId = "sha256:56031f66eb0cef2e2e5cb2d1dabafaa0ebcd0a18a507d313b5bdb8c0472c5eba";
        if (this.findImageWithId(this.expectedImageId, (List)this.dockerClient.listImagesCmd().exec()) != null) {
            this.dockerClient.removeImageCmd(this.expectedImageId).exec();
        }
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        this.dockerClient.removeImageCmd(this.expectedImageId).exec();
        super.afterMethod(result);
    }

    @Test
    public void loadImageFromTar() throws Exception {
        try (InputStream uploadStream = Files.newInputStream(TestResources.getApiImagesLoadTestTarball(), new OpenOption[0]);){
            this.dockerClient.loadImageCmd(uploadStream).exec();
        }
        Image image = this.findImageWithId(this.expectedImageId, (List)this.dockerClient.listImagesCmd().exec());
        MatcherAssert.assertThat((String)"Can't find expected image after loading from a tar archive!", (Object)image, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((String)"Image after loading from a tar archive has wrong tags!", Arrays.asList(image.getRepoTags()), (Matcher)IsEqual.equalTo(Collections.singletonList("docker-java/load:1.0")));
    }

    private Image findImageWithId(String id, List<Image> images) {
        for (Image image : images) {
            if (!id.equals(image.getId())) continue;
            return image;
        }
        return null;
    }
}

