/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class RemoveNetworkCmdImplTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(RemoveNetworkCmdImplTest.class);

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void removeNetwork() throws DockerException {
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("test-network").exec();
        LOG.info("Removing network: {}", (Object)network.getId());
        this.dockerClient.removeNetworkCmd(network.getId()).exec();
        List networks = (List)this.dockerClient.listNetworksCmd().exec();
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)network.getId()))));
        MatcherAssert.assertThat((Object)networks, (Matcher)matcher);
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void removeNonExistingContainer() throws DockerException {
        this.dockerClient.removeNetworkCmd("non-existing").exec();
    }
}

