/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.dockerfile;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.dockerfile.DockerfileStatement;
import com.google.common.base.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DockerfileStatementAddTest {
    private static final Logger LOG = LoggerFactory.getLogger(DockerfileStatementAddTest.class);

    @DataProvider(name="valid scenarios")
    public Object[][] validScenarios() {
        return new Object[][]{{"ADD src dest", Matchers.contains((Object[])new String[]{"src"}), "dest"}, {"ADD \"src file\" \"dest\"", Matchers.contains((Object[])new String[]{"src file"}), "dest"}, {"ADD src\"file dest", Matchers.contains((Object[])new String[]{"src\"file"}), "dest"}, {"ADD src1 src2 dest", Matchers.containsInAnyOrder((Object[])new String[]{"src1", "src2"}), "dest"}, {"COPY src dest", Matchers.contains((Object[])new String[]{"src"}), "dest"}, {"COPY \"src file\" \"dest\"", Matchers.contains((Object[])new String[]{"src file"}), "dest"}, {"COPY src\"file dest", Matchers.contains((Object[])new String[]{"src\"file"}), "dest"}, {"COPY src1 src2 dest", Matchers.containsInAnyOrder((Object[])new String[]{"src1", "src2"}), "dest"}};
    }

    @Test(dataProvider="valid scenarios")
    public void testAddOrCopyPattern(String command, Matcher matchesExpectation, String expectedDest) {
        Optional optionalAdd = DockerfileStatement.Add.create((String)command);
        MatcherAssert.assertThat((Object)optionalAdd.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DockerfileStatement.Add)optionalAdd.get()).sources, (Matcher)matchesExpectation);
        MatcherAssert.assertThat((Object)((DockerfileStatement.Add)optionalAdd.get()).destination, (Matcher)Matchers.is((Object)expectedDest));
    }

    @Test(expectedExceptions={DockerClientException.class})
    public void shouldThrowExceptionIfDestNotSpecified() {
        DockerfileStatement.Add.create((String)"ADD src");
    }
}

