/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class CommitCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void commit() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"touch", "/test"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        LOG.info("Committing container: {}", (Object)container.toString());
        String imageId = this.dockerClient.commitCmd(container.getId()).exec();
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)HasFieldWithValue.hasField((String)"container", (Matcher)Matchers.startsWith((String)container.getId())));
        MatcherAssert.assertThat((Object)inspectImageResponse.getContainerConfig().getImage(), (Matcher)Matchers.equalTo((Object)"busybox"));
        InspectImageResponse busyboxImg = this.dockerClient.inspectImageCmd("busybox").exec();
        MatcherAssert.assertThat((Object)inspectImageResponse.getParent(), (Matcher)Matchers.equalTo((Object)busyboxImg.getId()));
    }

    @Test
    public void commitWithLabels() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"touch", "/test"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        LOG.info("Committing container: {}", (Object)container.toString());
        ImmutableMap labels = ImmutableMap.of((Object)"label1", (Object)"abc", (Object)"label2", (Object)"123");
        String imageId = this.dockerClient.commitCmd(container.getId()).withLabels((Map)labels).exec();
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        Map responseLabels = inspectImageResponse.getContainerConfig().getLabels();
        MatcherAssert.assertThat(responseLabels.get("label1"), (Matcher)Matchers.equalTo((Object)"abc"));
        MatcherAssert.assertThat(responseLabels.get("label2"), (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void commitNonExistingContainer() throws DockerException {
        this.dockerClient.commitCmd("non-existent").exec();
    }
}

