/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class ConnectToNetworkCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void connectToNetwork() throws InterruptedException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("testNetwork").exec();
        this.dockerClient.connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).exec();
        Network updatedNetwork = this.dockerClient.inspectNetworkCmd().withNetworkId(network.getId()).exec();
        ConnectToNetworkCmdExecTest.assertTrue((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        ConnectToNetworkCmdExecTest.assertNotNull(inspectContainerResponse.getNetworkSettings().getNetworks().get("testNetwork"));
    }

    @Test
    public void connectToNetworkWithContainerNetwork() throws InterruptedException {
        String NETWORK_SUBNET = "10.100.101.0/24";
        String NETWORK_NAME = "nettyTestNetwork";
        String CONTAINER_IP = "10.100.101.100";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        try {
            this.dockerClient.removeNetworkCmd("nettyTestNetwork").exec();
        }
        catch (DockerException dockerException) {
            // empty catch block
        }
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("nettyTestNetwork").withIpam(new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet("10.100.101.0/24")})).exec();
        this.dockerClient.connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).withContainerNetwork(new ContainerNetwork().withAliases(new String[]{"aliasName"}).withIpamConfig(new ContainerNetwork.Ipam().withIpv4Address("10.100.101.100"))).exec();
        Network updatedNetwork = this.dockerClient.inspectNetworkCmd().withNetworkId(network.getId()).exec();
        Network.ContainerNetworkConfig containerNetworkConfig = (Network.ContainerNetworkConfig)updatedNetwork.getContainers().get(container.getId());
        ConnectToNetworkCmdExecTest.assertNotNull((Object)containerNetworkConfig);
        Assert.assertThat((Object)containerNetworkConfig.getIpv4Address(), (Matcher)Is.is((Object)"10.100.101.100/24"));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        ContainerNetwork testNetwork = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get("nettyTestNetwork");
        ConnectToNetworkCmdExecTest.assertNotNull((Object)testNetwork);
        Assert.assertThat((Object)testNetwork.getAliases(), (Matcher)Matchers.hasItem((Object)"aliasName"));
        ConnectToNetworkCmdExecTest.assertEquals((String)testNetwork.getGateway(), (String)"10.100.101.1");
        ConnectToNetworkCmdExecTest.assertEquals((String)testNetwork.getIpAddress(), (String)"10.100.101.100");
    }
}

