/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class CopyArchiveFromContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void copyFromContainer() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("docker-java-itest-copyFromContainer").withCmd(new String[]{"touch", "/copyFromContainer"}).exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InputStream response = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "/copyFromContainer").exec();
        Boolean bytesAvailable = response.available() > 0;
        CopyArchiveFromContainerCmdExecTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied from the container.");
        String responseAsString = this.asString(response);
        CopyArchiveFromContainerCmdExecTest.assertNotNull((Object)responseAsString);
        CopyArchiveFromContainerCmdExecTest.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void copyFromNonExistingContainer() throws Exception {
        this.dockerClient.copyArchiveFromContainerCmd("non-existing", "/test").exec();
    }

    @Test
    public void copyFromContainerBinaryFile() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("docker-java-itest-copyFromContainerBinaryFile").exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        Path temp = Files.createTempFile("", ".tar.gz", new FileAttribute[0]);
        Path binaryFile = Paths.get("src/test/resources/testCopyFromArchive/binary.dat", new String[0]);
        CompressArchiveUtil.tar((Path)binaryFile, (Path)temp, (boolean)true, (boolean)false);
        try (InputStream uploadStream = Files.newInputStream(temp, new OpenOption[0]);){
            this.dockerClient.copyArchiveToContainerCmd(container.getId()).withTarInputStream(uploadStream).exec();
        }
        InputStream response = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "/binary.dat").exec();
        Boolean bytesAvailable = response.available() > 0;
        CopyArchiveFromContainerCmdExecTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied from the container.");
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(response);){
            TarArchiveEntry nextTarEntry = tarInputStream.getNextTarEntry();
            CopyArchiveFromContainerCmdExecTest.assertEquals((String)nextTarEntry.getName(), (String)"binary.dat");
            try (InputStream binaryFileInputStream = Files.newInputStream(binaryFile, StandardOpenOption.READ);){
                CopyArchiveFromContainerCmdExecTest.assertTrue((boolean)IOUtils.contentEquals((InputStream)binaryFileInputStream, (InputStream)tarInputStream));
            }
            CopyArchiveFromContainerCmdExecTest.assertNull((Object)tarInputStream.getNextTarEntry(), (String)"Nothing except binary.dat is expected to be copied.");
        }
    }
}

