/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class DisconnectFromNetworkCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void disconnectFromNetwork() throws InterruptedException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("testNetwork").exec();
        this.dockerClient.connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).exec();
        Network updatedNetwork = this.dockerClient.inspectNetworkCmd().withNetworkId(network.getId()).exec();
        DisconnectFromNetworkCmdExecTest.assertTrue((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
        this.dockerClient.disconnectFromNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).exec();
        updatedNetwork = this.dockerClient.inspectNetworkCmd().withNetworkId(network.getId()).exec();
        DisconnectFromNetworkCmdExecTest.assertFalse((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
    }

    @Test
    public void forceDisconnectFromNetwork() throws InterruptedException {
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("testNetwork").exec();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withNetworkMode("testNetwork").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.dockerClient.disconnectFromNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).withForce(Boolean.valueOf(true)).exec();
        Network updatedNetwork = this.dockerClient.inspectNetworkCmd().withNetworkId(network.getId()).exec();
        DisconnectFromNetworkCmdExecTest.assertFalse((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
    }
}

