/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.github.dockerjava.utils.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class ExecStartCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void execStart() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).exec();
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InputStream response = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
        Boolean bytesAvailable = response.available() > 0;
        ExecStartCmdExecTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied from the container.");
        String responseAsString = this.asString(response);
        ExecStartCmdExecTest.assertNotNull((Object)responseAsString);
        ExecStartCmdExecTest.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void execStartAttached() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).exec();
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InputStream response = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
        Boolean bytesAvailable = response.available() > 0;
        ExecStartCmdExecTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied from the container.");
        String responseAsString = this.asString(response);
        ExecStartCmdExecTest.assertNotNull((Object)responseAsString);
        ExecStartCmdExecTest.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void execStartAttachStdin() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ByteArrayInputStream stdin = new ByteArrayInputStream("STDIN\n".getBytes("UTF-8"));
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).withCmd(new String[]{"cat"}).exec();
        boolean completed = ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true)).withStdIn((InputStream)stdin).exec((ResultCallback)new ExecStartResultCallback((OutputStream)stdout, (OutputStream)System.err))).awaitCompletion(5L, TimeUnit.SECONDS);
        ExecStartCmdExecTest.assertTrue((boolean)completed, (String)"The process was not finished.");
        ExecStartCmdExecTest.assertEquals((String)stdout.toString("UTF-8"), (String)"STDIN\n");
    }

    @Test
    public void execStartAttachStdinToShell() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ByteArrayInputStream stdin = new ByteArrayInputStream("ls\n".getBytes());
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).withTty(Boolean.valueOf(false)).withCmd(new String[]{"/bin/sh"}).exec();
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withStdIn((InputStream)stdin).exec((ResultCallback)new ExecStartResultCallback((OutputStream)stdout, (OutputStream)System.err))).awaitCompletion();
        MatcherAssert.assertThat((Object)stdout.toString(), (Matcher)Matchers.containsString((String)"etc\n"));
    }

    @Test
    public void execStartNotAttachedStdin() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ByteArrayInputStream stdin = new ByteArrayInputStream("echo STDIN\n".getBytes());
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(false)).withCmd(new String[]{"/bin/sh"}).exec();
        boolean completed = ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withStdIn((InputStream)stdin).exec((ResultCallback)new ExecStartResultCallback((OutputStream)stdout, (OutputStream)System.err))).awaitCompletion(5L, TimeUnit.SECONDS);
        ExecStartCmdExecTest.assertEquals((String)stdout.toString(), (String)"");
        if (TestUtils.getVersion(this.dockerClient).isGreaterOrEqual(RemoteApiVersion.VERSION_1_23)) {
            ExecStartCmdExecTest.assertFalse((boolean)completed, (String)"The process was not finished.");
        } else {
            ExecStartCmdExecTest.assertTrue((boolean)completed, (String)"with v1.22 of the remote api the server closed the connection when no stdin was attached while exec create, so completed was true");
        }
    }
}

