/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class InfoCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void info() throws DockerException {
        if (((List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()).size() == 0) {
            CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("docker-java-itest-info").withCmd(new String[]{"touch", "/test"}).exec();
            LOG.info("Created container: {}", (Object)container);
            MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
            this.dockerClient.startContainerCmd(container.getId()).exec();
        }
        Info dockerInfo = (Info)this.dockerClient.infoCmd().exec();
        LOG.info(dockerInfo.toString());
        InfoCmdExecTest.assertTrue((boolean)dockerInfo.toString().contains("containers"));
        InfoCmdExecTest.assertTrue((boolean)dockerInfo.toString().contains("images"));
        InfoCmdExecTest.assertTrue((boolean)dockerInfo.toString().contains("debug"));
        InfoCmdExecTest.assertTrue((dockerInfo.getContainers() > 0 ? 1 : 0) != 0);
        InfoCmdExecTest.assertTrue((dockerInfo.getImages() > 0 ? 1 : 0) != 0);
        InfoCmdExecTest.assertTrue((dockerInfo.getNFd() > 0 ? 1 : 0) != 0);
        InfoCmdExecTest.assertTrue((dockerInfo.getNGoroutines() > 0 ? 1 : 0) != 0);
        InfoCmdExecTest.assertTrue((dockerInfo.getNCPU() > 0 ? 1 : 0) != 0);
    }
}

