/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import ch.lambdaj.Lambda;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class ListContainersCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testListContainers() throws Exception {
        String testImage = "busybox";
        List containers = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        MatcherAssert.assertThat((Object)containers, (Matcher)Matchers.notNullValue());
        LOG.info("Container List: {}", (Object)containers);
        int size = containers.size();
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd(testImage).withCmd(new String[]{"echo"}).exec();
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getImage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testImage)));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        LOG.info("container id: " + container1.getId());
        List containers2 = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        for (Container container : containers2) {
            LOG.info("listContainer: id=" + container.getId() + " image=" + container.getImage());
        }
        MatcherAssert.assertThat((Object)(size + 1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)containers2.size())));
        Matcher matcher = Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
        List filteredContainers = Lambda.filter((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())), (Iterable)containers2);
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        for (Container container : filteredContainers) {
            LOG.info("filteredContainer: " + container);
        }
        Container container2 = (Container)filteredContainers.get(0);
        MatcherAssert.assertThat((Object)container2.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)container2.getImage(), (Matcher)Matchers.startsWith((String)testImage));
    }

    @Test
    public void testListContainersWithLabelsFilter() throws Exception {
        String testImage = "busybox";
        ((PullImageResultCallback)this.dockerClient.pullImageCmd(testImage).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
        List containers = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        MatcherAssert.assertThat((Object)containers, (Matcher)Matchers.notNullValue());
        LOG.info("Container List: {}", (Object)containers);
        int size = containers.size();
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd(testImage).withCmd(new String[]{"echo"}).exec();
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getImage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testImage)));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        LOG.info("container id: " + container1.getId());
        List containers2 = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        for (Container container : containers2) {
            LOG.info("listContainer: id=" + container.getId() + " image=" + container.getImage());
        }
        MatcherAssert.assertThat((Object)(size + 1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)containers2.size())));
        Matcher matcher = Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
        List filteredContainers = Lambda.filter((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container1.getId())), (Iterable)containers2);
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        for (Container container : filteredContainers) {
            LOG.info("filteredContainer: " + container);
        }
        Container container2 = (Container)filteredContainers.get(0);
        MatcherAssert.assertThat((Object)container2.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)container2.getImage(), (Matcher)Matchers.startsWith((String)testImage));
        ImmutableMap labels = ImmutableMap.of((Object)"test", (Object)"docker-java");
        this.dockerClient.createContainerCmd(testImage).withCmd(new String[]{"echo"}).withLabels((Map)labels).exec();
        filteredContainers = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter((Map)labels).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Container container3 = (Container)filteredContainers.get(0);
        MatcherAssert.assertThat((Object)container3.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)container3.getImage(), (Matcher)Matchers.startsWith((String)testImage));
        filteredContainers = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withLabelFilter(new String[]{"test"}).exec();
        MatcherAssert.assertThat((Object)filteredContainers.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        container3 = (Container)filteredContainers.get(0);
        MatcherAssert.assertThat((Object)container3.getCommand(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)container3.getImage(), (Matcher)Matchers.startsWith((String)testImage));
        ListContainersCmdExecTest.assertEquals((Map)container3.getLabels(), (Map)labels);
    }
}

