/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Statistics;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class StatsCmdExecTest
extends AbstractNettyDockerClientTest {
    private static int NUM_STATS = 5;

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void testStatsStreaming() throws InterruptedException, IOException {
        TimeUnit.SECONDS.sleep(1L);
        CountDownLatch countDownLatch = new CountDownLatch(NUM_STATS);
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        StatsCallbackTest statsCallback = (StatsCallbackTest)this.dockerClient.statsCmd(container.getId()).exec((ResultCallback)new StatsCallbackTest(countDownLatch));
        countDownLatch.await(3L, TimeUnit.SECONDS);
        Boolean gotStats = statsCallback.gotStats();
        LOG.info("Stop stats collection");
        statsCallback.close();
        LOG.info("Stopping container");
        this.dockerClient.stopContainerCmd(container.getId()).exec();
        this.dockerClient.removeContainerCmd(container.getId()).exec();
        LOG.info("Completed test");
        StatsCmdExecTest.assertTrue((boolean)gotStats, (String)"Expected true");
    }

    private class StatsCallbackTest
    extends ResultCallbackTemplate<StatsCallbackTest, Statistics> {
        private final CountDownLatch countDownLatch;
        private Boolean gotStats = false;

        public StatsCallbackTest(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void onNext(Statistics stats) {
            AbstractNettyDockerClientTest.LOG.info("Received stats #{}: {}", (Object)this.countDownLatch.getCount(), (Object)stats);
            if (stats != null) {
                this.gotStats = true;
            }
            this.countDownLatch.countDown();
        }

        public Boolean gotStats() {
            return this.gotStats;
        }
    }
}

