/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.UpdateContainerResponse;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.github.dockerjava.utils.TestUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class UpdateContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(UpdateContainerCmdExecTest.class);
    private static final String BUSYBOX_IMAGE = "busybox";

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void updateContainer() throws DockerException, IOException {
        RemoteApiVersion apiVersion = TestUtils.getVersion(this.dockerClient);
        if (!apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_22)) {
            throw new SkipException("API version should be >= 1.22");
        }
        CreateContainerResponse response = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).exec();
        String containerId = response.getId();
        this.dockerClient.startContainerCmd(containerId).exec();
        InspectContainerResponse inspectBefore = this.dockerClient.inspectContainerCmd(containerId).exec();
        HostConfig beforeHostConfig = inspectBefore.getHostConfig();
        UpdateContainerResponse updateResponse = (UpdateContainerResponse)this.dockerClient.updateContainerCmd(containerId).withBlkioWeight(Integer.valueOf(300)).withCpuShares(Integer.valueOf(512)).withCpuPeriod(Integer.valueOf(100000)).withCpuQuota(Integer.valueOf(50000)).withCpusetMems("0").withMemory(Long.valueOf(314572800L)).withMemoryReservation(Long.valueOf(0xC800000L)).exec();
        InspectContainerResponse inspectAfter = this.dockerClient.inspectContainerCmd(containerId).exec();
        HostConfig afterHostConfig = inspectAfter.getHostConfig();
        MatcherAssert.assertThat((Object)afterHostConfig.getMemory(), (Matcher)CoreMatchers.is((Object)314572800L));
        MatcherAssert.assertThat((Object)afterHostConfig.getCpuShares(), (Matcher)CoreMatchers.is((Object)512));
        MatcherAssert.assertThat((Object)afterHostConfig.getCpuPeriod(), (Matcher)CoreMatchers.is((Object)100000));
        MatcherAssert.assertThat((Object)afterHostConfig.getCpuQuota(), (Matcher)CoreMatchers.is((Object)50000));
        MatcherAssert.assertThat((Object)afterHostConfig.getCpusetMems(), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)afterHostConfig.getMemoryReservation(), (Matcher)CoreMatchers.is((Object)0xC800000L));
    }
}

