/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.handler;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.netty.handler.HttpResponseStreamHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpResponseStreamHandlerTest {
    @Test
    public void testNoBytesSkipped() throws Exception {
        ResultCallbackTest callback = new ResultCallbackTest();
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler((ResultCallback)callback);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        ByteBuf buffer = this.generateByteBuf();
        streamHandler.channelRead0(ctx, buffer);
        streamHandler.channelInactive(ctx);
        try (InputStream inputStream = callback.getInputStream();){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)inputStream, (InputStream)new ByteBufInputStream(buffer)));
        }
    }

    @Test
    public void testReadByteByByte() throws Exception {
        ResultCallbackTest callback = new ResultCallbackTest();
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler((ResultCallback)callback);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        ByteBuf buffer = this.generateByteBuf();
        streamHandler.channelRead0(ctx, buffer);
        streamHandler.channelInactive(ctx);
        try (InputStream inputStream = callback.getInputStream();){
            for (int i = 0; i < buffer.readableBytes(); ++i) {
                int b = inputStream.read();
                Assert.assertEquals((int)b, (int)buffer.getByte(i));
            }
            Assert.assertTrue((inputStream.read() == -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCloseResponseStreamBeforeWrite() throws Exception {
        HttpResponseStreamHandler.HttpResponseInputStream inputStream = new HttpResponseStreamHandler.HttpResponseInputStream();
        ByteBuf buffer = this.generateByteBuf();
        inputStream.write(buffer);
        inputStream.close();
        inputStream.write(buffer);
    }

    @Test
    public void testCloseResponseStreamOnWrite() throws Exception {
        final HttpResponseStreamHandler.HttpResponseInputStream inputStream = new HttpResponseStreamHandler.HttpResponseInputStream();
        final ByteBuf buffer = this.generateByteBuf();
        final CountDownLatch firstWrite = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> submit = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    inputStream.write(buffer);
                    firstWrite.countDown();
                    inputStream.write(buffer);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        firstWrite.await();
        Assert.assertTrue((inputStream.available() > 0 ? 1 : 0) != 0);
        Thread.sleep(500L);
        inputStream.close();
        submit.get();
    }

    @Test(expectedExceptions={IOException.class})
    public void testReadClosedResponseStream() throws Exception {
        HttpResponseStreamHandler.HttpResponseInputStream inputStream = new HttpResponseStreamHandler.HttpResponseInputStream();
        ByteBuf buffer = this.generateByteBuf();
        inputStream.write(buffer);
        inputStream.close();
        inputStream.read();
    }

    private ByteBuf generateByteBuf() {
        byte[] array = new byte[256];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)i;
        }
        return Unpooled.copiedBuffer((byte[])array);
    }

    private static class ResultCallbackTest
    extends ResultCallbackTemplate<ResultCallbackTest, InputStream> {
        private InputStream stream;

        private ResultCallbackTest() {
        }

        public void onNext(InputStream stream) {
            this.stream = stream;
        }

        private InputStream getInputStream() {
            return this.stream;
        }
    }
}

