/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.test.serdes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.test.serdes.JSONResourceRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.testng.Assert;

public class JSONTestHelper {
    public static String readString(JSONResourceRef resource) throws IOException {
        try (InputStream istream = resource.getResourceClass().getResourceAsStream(resource.getFileName());){
            if (istream == null) {
                throw new IOException("Cannot retrieve resource " + resource.getFileName());
            }
            String string = IOUtils.toString((InputStream)istream, (String)"UTF-8");
            return string;
        }
    }

    public static <TClass> TClass readObject(JSONResourceRef resource, Class<TClass> tclass) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String str = JSONTestHelper.readString(resource);
        return (TClass)mapper.readValue(str, tclass);
    }

    public static <TClass> TClass testRoundTrip(JSONResourceRef resource, Class<TClass> tclass) throws IOException, AssertionError {
        TClass item = JSONTestHelper.readObject(resource, tclass);
        Assert.assertNotNull(item);
        return JSONTestHelper.testRoundTrip(item, tclass);
    }

    public static <TClass> TClass testRoundTrip(TClass item) throws IOException, AssertionError {
        return JSONTestHelper.testRoundTrip(item, item.getClass());
    }

    public static <TClass> TClass testRoundTrip(TClass item, Class<TClass> asclass) throws IOException, AssertionError {
        ObjectMapper mapper = new ObjectMapper();
        String serialized1 = mapper.writeValueAsString(item);
        JsonNode json1 = mapper.readTree(serialized1);
        Object deserialized1 = mapper.readValue(serialized1, asclass);
        String serialized2 = mapper.writeValueAsString(deserialized1);
        JsonNode json2 = mapper.readTree(serialized2);
        Object deserialized2 = mapper.readValue(serialized2, asclass);
        Assert.assertEquals((Iterable)json2, (Iterable)json1, (String)"JSONs must be equal after the second roundtrip");
        return (TClass)deserialized2;
    }
}

