/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core;

public class ServiceInstance {
    private final String containerName;
    private final String gatewayAddress;
    private final int gatewayPort;
    private final int containerPort;
    private String containerIp;
    private String containerId;
    private String statusDetails;
    private Status status;

    public String getContainerName() {
        return this.containerName;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public String getIp() {
        return this.getGatewayAddress();
    }

    public int getGatewayPort() {
        return this.gatewayPort;
    }

    public int getPort() {
        return this.getGatewayPort();
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerIp() {
        return this.containerIp;
    }

    public int getContainerPort() {
        return this.containerPort;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public boolean hasStatus(Status status) {
        return this.status.equals((Object)status);
    }

    ServiceInstance(String containerName, String gatewayAddress, int gatewayPort, int containerPort, String containerIp, String containerId, String statusDetails, Status status) {
        this.containerName = containerName;
        this.gatewayAddress = gatewayAddress;
        this.gatewayPort = gatewayPort;
        this.containerPort = containerPort;
        this.containerIp = containerIp;
        this.containerId = containerId;
        this.statusDetails = statusDetails;
        this.status = status;
    }

    public static ServiceInstanceBuilder builder() {
        return new ServiceInstanceBuilder();
    }

    public ServiceInstance withContainerName(String containerName) {
        return this.containerName == containerName ? this : new ServiceInstance(containerName, this.gatewayAddress, this.gatewayPort, this.containerPort, this.containerIp, this.containerId, this.statusDetails, this.status);
    }

    public ServiceInstance withGatewayAddress(String gatewayAddress) {
        return this.gatewayAddress == gatewayAddress ? this : new ServiceInstance(this.containerName, gatewayAddress, this.gatewayPort, this.containerPort, this.containerIp, this.containerId, this.statusDetails, this.status);
    }

    public ServiceInstance withGatewayPort(int gatewayPort) {
        return this.gatewayPort == gatewayPort ? this : new ServiceInstance(this.containerName, this.gatewayAddress, gatewayPort, this.containerPort, this.containerIp, this.containerId, this.statusDetails, this.status);
    }

    public ServiceInstance withContainerPort(int containerPort) {
        return this.containerPort == containerPort ? this : new ServiceInstance(this.containerName, this.gatewayAddress, this.gatewayPort, containerPort, this.containerIp, this.containerId, this.statusDetails, this.status);
    }

    public ServiceInstance withContainerIp(String containerIp) {
        return this.containerIp == containerIp ? this : new ServiceInstance(this.containerName, this.gatewayAddress, this.gatewayPort, this.containerPort, containerIp, this.containerId, this.statusDetails, this.status);
    }

    public ServiceInstance withContainerId(String containerId) {
        return this.containerId == containerId ? this : new ServiceInstance(this.containerName, this.gatewayAddress, this.gatewayPort, this.containerPort, this.containerIp, containerId, this.statusDetails, this.status);
    }

    public ServiceInstance withStatusDetails(String statusDetails) {
        return this.statusDetails == statusDetails ? this : new ServiceInstance(this.containerName, this.gatewayAddress, this.gatewayPort, this.containerPort, this.containerIp, this.containerId, statusDetails, this.status);
    }

    public ServiceInstance withStatus(Status status) {
        return this.status == status ? this : new ServiceInstance(this.containerName, this.gatewayAddress, this.gatewayPort, this.containerPort, this.containerIp, this.containerId, this.statusDetails, status);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceInstance)) {
            return false;
        }
        ServiceInstance other = (ServiceInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$containerId = this.getContainerId();
        String other$containerId = other.getContainerId();
        return !(this$containerId == null ? other$containerId != null : !this$containerId.equals(other$containerId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $containerId = this.getContainerId();
        result = result * 59 + ($containerId == null ? 43 : $containerId.hashCode());
        return result;
    }

    public static class ServiceInstanceBuilder {
        private String containerName;
        private String gatewayAddress;
        private int gatewayPort;
        private int containerPort;
        private String containerIp;
        private String containerId;
        private String statusDetails;
        private Status status;

        ServiceInstanceBuilder() {
        }

        public ServiceInstanceBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public ServiceInstanceBuilder gatewayAddress(String gatewayAddress) {
            this.gatewayAddress = gatewayAddress;
            return this;
        }

        public ServiceInstanceBuilder gatewayPort(int gatewayPort) {
            this.gatewayPort = gatewayPort;
            return this;
        }

        public ServiceInstanceBuilder containerPort(int containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public ServiceInstanceBuilder containerIp(String containerIp) {
            this.containerIp = containerIp;
            return this;
        }

        public ServiceInstanceBuilder containerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public ServiceInstanceBuilder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public ServiceInstanceBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public ServiceInstance build() {
            return new ServiceInstance(this.containerName, this.gatewayAddress, this.gatewayPort, this.containerPort, this.containerIp, this.containerId, this.statusDetails, this.status);
        }

        public String toString() {
            return "ServiceInstance.ServiceInstanceBuilder(containerName=" + this.containerName + ", gatewayAddress=" + this.gatewayAddress + ", gatewayPort=" + this.gatewayPort + ", containerPort=" + this.containerPort + ", containerIp=" + this.containerIp + ", containerId=" + this.containerId + ", statusDetails=" + this.statusDetails + ", status=" + (Object)((Object)this.status) + ")";
        }
    }

    public static enum Status {
        STARTED,
        DISCOVERED,
        ABORTED,
        TERMINATED,
        TERMINATION_FAILED;

    }
}

