/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core.annotation.impl;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerunit.core.annotation.ExtensionInterpreter;
import com.github.dockerunit.core.annotation.PublishPort;
import com.github.dockerunit.core.internal.ServiceDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;

public class PublishPortExtensionInterpreter
implements ExtensionInterpreter<PublishPort> {
    @Override
    public CreateContainerCmd build(ServiceDescriptor sd, CreateContainerCmd cmd, PublishPort pb) {
        ExposedPort containerPort = this.toExposedPort(pb);
        ArrayList<ExposedPort> ports = new ArrayList<ExposedPort>(Arrays.asList(cmd.getExposedPorts()));
        ports.add(containerPort);
        HostConfig hc = cmd.getHostConfig();
        Ports bindings = Optional.ofNullable(hc.getPortBindings()).orElse(new Ports());
        bindings.bind(containerPort, this.toHostBinding(pb));
        return cmd.withExposedPorts(ports).withHostConfig(hc.withPortBindings(bindings));
    }

    private ExposedPort toExposedPort(PublishPort pb) {
        return pb.protocol() == PublishPort.Protocol.TCP ? ExposedPort.tcp((int)pb.container()) : ExposedPort.udp((int)pb.container());
    }

    private Ports.Binding toHostBinding(PublishPort pb) {
        return pb.hostIp().isEmpty() ? Ports.Binding.bindPort((int)pb.host()) : Ports.Binding.bindIpAndPort((String)pb.hostIp(), (int)pb.host());
    }
}

