/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core.internal.reflect;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerunit.core.annotation.ContainerBuilder;
import com.github.dockerunit.core.annotation.ExtensionMarker;
import com.github.dockerunit.core.annotation.RepeatableWithSvc;
import com.github.dockerunit.core.annotation.Svc;
import com.github.dockerunit.core.annotation.WithSvc;
import com.github.dockerunit.core.internal.ServiceDescriptor;
import com.github.dockerunit.core.internal.UsageDescriptor;
import com.github.dockerunit.core.internal.reflect.DefaultServiceDescriptor;
import com.github.dockerunit.core.internal.reflect.DefaultUsageDescriptor;
import com.github.dockerunit.core.internal.reflect.UsageDescriptorBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultUsageDescriptorBuilder
implements UsageDescriptorBuilder {
    @Override
    public UsageDescriptor buildDescriptor(Method method) {
        return this.buildDescriptor((AnnotatedElement)method);
    }

    @Override
    public UsageDescriptor buildDescriptor(Class<?> klass) {
        return this.buildDescriptor((AnnotatedElement)klass);
    }

    private UsageDescriptor buildDescriptor(AnnotatedElement element) {
        List<WithSvc> requirements = this.getWithSvcUsages(element);
        List<ServiceDescriptor> descriptors = this.asDescriptors(requirements);
        return new DefaultUsageDescriptor(descriptors);
    }

    private List<ServiceDescriptor> asDescriptors(List<WithSvc> requirements) {
        List<ServiceDescriptor> descriptors = requirements.stream().map(this::buildDescriptor).collect(Collectors.toList());
        return descriptors;
    }

    private ServiceDescriptor buildDescriptor(WithSvc withSvc) {
        DefaultServiceDescriptor.DefaultServiceDescriptorBuilder builder = DefaultServiceDescriptor.builder();
        this.checkServiceClass(withSvc.svc());
        try {
            builder.instance(withSvc.svc().newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate svc class " + withSvc.svc().getName());
        }
        builder.replicas(this.extractReplicas(withSvc)).priority(withSvc.priority()).containerName(withSvc.containerNamePrefix()).svcDefinition(this.findSvc(withSvc.svc())).customisationHook(this.findCustomisationHook(withSvc)).options(this.extractOptions(withSvc.svc()));
        return builder.build();
    }

    private List<? extends Annotation> extractOptions(Class<?> service) {
        return Arrays.asList(service.getDeclaredAnnotations()).stream().filter(a -> a.annotationType().isAnnotationPresent(ExtensionMarker.class)).collect(Collectors.toList());
    }

    private void checkServiceClass(Class<?> service) {
        Optional<Constructor<?>> c;
        int modifiers;
        String className = service.getSimpleName();
        StringBuffer buffer = new StringBuffer();
        if (service.isInterface()) {
            buffer.append(className + " cannot be an interface. ");
        }
        if (service.isEnum()) {
            buffer.append(className + " cannot be an enum. ");
        }
        if (service.isSynthetic()) {
            buffer.append(className + " cannot be synthetic. ");
        }
        if (service.isAnnotation()) {
            buffer.append(className + " cannot be an annotation. ");
        }
        if (service.isArray()) {
            buffer.append(className + " cannot be an array. ");
        }
        if (service.isAnonymousClass()) {
            buffer.append(className + " cannot be anonymous. ");
        }
        if (service.isLocalClass()) {
            buffer.append(className + " cannot be a local class. ");
        }
        if (service.isMemberClass()) {
            buffer.append(className + " cannot be a member class. ");
        }
        if (Modifier.isAbstract(modifiers = service.getModifiers())) {
            buffer.append("Service class cannot be abstract. ");
        }
        if (!Modifier.isPublic(modifiers)) {
            buffer.append("Service class must be public. ");
        }
        if (Modifier.isStatic(modifiers)) {
            buffer.append("Service class cannot be static. ");
        }
        if (!(c = this.findSuitableContructor(service.getDeclaredConstructors())).isPresent()) {
            buffer.append("Service class must provide a public zero args constructor. ");
        }
        if (buffer.length() > 0) {
            throw new RuntimeException(buffer.toString());
        }
    }

    private Optional<Constructor<?>> findSuitableContructor(Constructor<?>[] declaredConstructors) {
        return Arrays.asList(declaredConstructors).stream().filter(c -> Modifier.isPublic(c.getModifiers()) && c.getParameterCount() == 0).findFirst();
    }

    private Method findCustomisationHook(WithSvc withSvc) {
        Optional<Method> opt = Arrays.asList(withSvc.svc().getDeclaredMethods()).stream().filter(m -> m.isAnnotationPresent(ContainerBuilder.class) && Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(CreateContainerCmd.class) && m.getReturnType().equals(CreateContainerCmd.class)).findFirst();
        return opt.orElse(null);
    }

    private int extractReplicas(WithSvc withSvc) {
        if (withSvc.replicas() < 1) {
            throw new RuntimeException("Cannot require less than one replica");
        }
        return withSvc.replicas();
    }

    private <T extends Annotation> T findRequiredAnnotation(Class<?> service, Class<T> annotationType) {
        if (!service.isAnnotationPresent(annotationType)) {
            throw new RuntimeException("No @" + annotationType.getSimpleName() + " has been specified on class " + service.getName());
        }
        return service.getAnnotation(annotationType);
    }

    private Svc findSvc(Class<?> service) {
        return this.findRequiredAnnotation(service, Svc.class);
    }

    private List<WithSvc> getWithSvcUsages(AnnotatedElement element) {
        WithSvc[] requirements;
        WithSvc[] withSvcArray = requirements = element.isAnnotationPresent(RepeatableWithSvc.class) ? element.getAnnotation(RepeatableWithSvc.class).value() : new WithSvc[]{};
        if (requirements.length == 0 && element.isAnnotationPresent(WithSvc.class)) {
            requirements = new WithSvc[]{element.getAnnotation(WithSvc.class)};
        }
        return Arrays.asList(requirements);
    }
}

