/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core.internal.service;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerunit.core.Service;
import com.github.dockerunit.core.ServiceInstance;
import com.github.dockerunit.core.annotation.ContainerBuilder;
import com.github.dockerunit.core.annotation.ExtensionInterpreter;
import com.github.dockerunit.core.annotation.ExtensionMarker;
import com.github.dockerunit.core.annotation.Svc;
import com.github.dockerunit.core.exception.ContainerException;
import com.github.dockerunit.core.internal.ServiceBuilder;
import com.github.dockerunit.core.internal.ServiceDescriptor;
import com.github.dockerunit.core.internal.service.DockerPullStatusManager;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DefaultServiceBuilder
implements ServiceBuilder {
    private static final Logger logger = Logger.getLogger(DefaultServiceBuilder.class.getSimpleName());

    @Override
    public Service build(ServiceDescriptor descriptor, DockerClient client) {
        HashSet<ServiceInstance> instances = new HashSet<ServiceInstance>();
        for (int i = 0; i < descriptor.getReplicas(); ++i) {
            instances.add(this.createInstance(descriptor, client, i));
        }
        return new Service(descriptor.getSvcName(), instances, descriptor);
    }

    private ServiceInstance createInstance(ServiceDescriptor descriptor, DockerClient client, int i) {
        String containerId = null;
        ServiceInstance.Status status = null;
        String statusDetails = null;
        CreateContainerCmd cmd = null;
        try {
            cmd = client.createContainerCmd(descriptor.getSvcDefinition().image());
            cmd = this.computeContainerName(descriptor, i, cmd);
            cmd = this.executeOptionBuilders(descriptor, cmd);
            if (descriptor.getCustomisationHook() != null) {
                cmd = this.executeCustomisationHook(descriptor.getCustomisationHook(), descriptor.getInstance(), cmd);
            }
            containerId = this.createAndStartContainer(cmd, descriptor.getSvcDefinition().pull(), client);
            status = ServiceInstance.Status.STARTED;
            statusDetails = "Started.";
        }
        catch (Throwable t) {
            if (t instanceof CompletionException) {
                if (t.getCause() != null && t.getCause() instanceof ContainerException) {
                    containerId = ((ContainerException)t.getCause()).getContainerId();
                    statusDetails = t.getCause().getCause() != null ? t.getCause().getCause().getMessage() : null;
                } else {
                    statusDetails = t.getCause() != null ? t.getCause().getMessage() : null;
                }
            } else {
                statusDetails = t.getMessage();
            }
            status = ServiceInstance.Status.ABORTED;
        }
        return ServiceInstance.builder().containerName(cmd.getName()).containerId(containerId).status(status).statusDetails(statusDetails).build();
    }

    private CreateContainerCmd computeContainerName(ServiceDescriptor dependency, int i, CreateContainerCmd cmd) {
        if (!dependency.getContainerName().isEmpty()) {
            String name = dependency.getReplicas() > 1 ? dependency.getContainerName() + "-" + (i + 1) : dependency.getContainerName();
            cmd = cmd.withName(name);
        }
        return cmd;
    }

    private String createAndStartContainer(CreateContainerCmd cmd, Svc.PullStrategy pullStrategy, DockerClient client) {
        CompletableFuture respFut = new CompletableFuture();
        String imageName = this.computeImageName(cmd.getImage());
        Optional<Image> image = this.findImage(imageName, client);
        CompletableFuture<Void> pullFut = !image.isPresent() || pullStrategy.equals((Object)Svc.PullStrategy.ALWAYS) ? this.pullImage(imageName, client) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)pullFut.exceptionally(ex -> {
            String msg = String.format("An error occurred while pulling image %s - %s", imageName, ex.getMessage());
            logger.warning(msg);
            respFut.completeExceptionally(new RuntimeException(msg));
            return null;
        })).thenRun(() -> {
            String containerId = this.startContainer(cmd, client);
            respFut.complete(containerId);
        })).exceptionally(ex -> {
            respFut.completeExceptionally(ex.getCause());
            return null;
        });
        respFut.exceptionally(ex -> {
            logger.severe("Cannot create container. Reason: " + ex.getMessage());
            return null;
        });
        return (String)respFut.join();
    }

    private String computeImageName(String cmdImageName) {
        return Arrays.asList(cmdImageName).stream().filter(s -> s.lastIndexOf("/") > s.lastIndexOf(":")).findFirst().map(s -> {
            s = s + ":latest";
            return s;
        }).orElse(cmdImageName);
    }

    private Optional<Image> findImage(String imageName, DockerClient client) {
        ListImagesCmd listImages = client.listImagesCmd();
        listImages.getFilters().put("reference", Collections.singletonList(imageName));
        return Optional.ofNullable(listImages.exec()).filter(images -> !images.isEmpty()).map(images -> (Image)images.get(0));
    }

    private CompletableFuture<Void> pullImage(final String imageName, DockerClient client) {
        PullImageCmd pullImageCmd = client.pullImageCmd(imageName);
        final CompletableFuture<Void> pullFut = new CompletableFuture<Void>();
        ResultCallback<PullResponseItem> resultCallback = new ResultCallback<PullResponseItem>(){
            private Closeable closeable;
            private DockerPullStatusManager manager;
            {
                this.manager = new DockerPullStatusManager(imageName);
            }

            public void close() throws IOException {
                try {
                    this.closeable.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot close closeable " + this.closeable, e);
                }
            }

            public void onStart(Closeable closeable) {
                this.closeable = closeable;
            }

            public void onNext(PullResponseItem object) {
                System.out.print(this.manager.update(object));
            }

            public void onError(Throwable throwable) {
                pullFut.completeExceptionally(throwable);
            }

            public void onComplete() {
                pullFut.complete(null);
            }
        };
        pullImageCmd.exec((ResultCallback)resultCallback);
        return pullFut;
    }

    private String startContainer(CreateContainerCmd cmd, DockerClient client) {
        CreateContainerResponse createResp = cmd.exec();
        StartContainerCmd startCmd = client.startContainerCmd(createResp.getId());
        try {
            startCmd.exec();
        }
        catch (Throwable t) {
            throw new ContainerException(createResp.getId(), t);
        }
        return startCmd.getContainerId();
    }

    private CreateContainerCmd executeCustomisationHook(Method customisationHook, Object instance, CreateContainerCmd cmd) {
        try {
            cmd = (CreateContainerCmd)customisationHook.invoke(instance, cmd);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while executing a method marked with @" + ContainerBuilder.class.getSimpleName() + ", svcDefinition " + customisationHook.getName() + " and declared in class " + instance.getClass().getName(), e);
        }
        return cmd;
    }

    private CreateContainerCmd executeOptionBuilders(ServiceDescriptor descriptor, CreateContainerCmd cmd) {
        for (Annotation annotation : descriptor.getOptions()) {
            Class<ExtensionInterpreter<?>> builderType = annotation.annotationType().getAnnotation(ExtensionMarker.class).value();
            ExtensionInterpreter<?> builder = null;
            Method buildMethod = null;
            try {
                builder = builderType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate " + ExtensionInterpreter.class.getSimpleName() + " of type " + builderType.getSimpleName() + " to handle annotation " + annotation.annotationType().getSimpleName() + " that has been detected on class " + descriptor.getInstance().getClass().getName(), e);
            }
            try {
                buildMethod = builderType.getDeclaredMethod("build", ServiceDescriptor.class, CreateContainerCmd.class, annotation.annotationType());
                cmd = (CreateContainerCmd)buildMethod.invoke(builder, descriptor, cmd, annotation);
            }
            catch (Exception e) {
                throw new RuntimeException("An error occurred while invoking the build method on builder class " + builderType.getName(), e);
            }
        }
        return cmd;
    }

    @Override
    public Service cleanup(Service s, DockerClient client) {
        return s.withInstances(s.getInstances().stream().map(si -> this.destroyInstance((ServiceInstance)si, client)).collect(Collectors.toSet()));
    }

    private ServiceInstance destroyInstance(ServiceInstance i, DockerClient client) {
        if (i.getContainerId() != null) {
            RemoveContainerCmd cmd = client.removeContainerCmd(i.getContainerId()).withForce(Boolean.valueOf(true));
            try {
                cmd.exec();
                return i.withStatus(ServiceInstance.Status.TERMINATED);
            }
            catch (NotFoundException e) {
                logger.warning("No container with id " + i.getContainerId() + " found");
                return i.withStatus(ServiceInstance.Status.TERMINATION_FAILED).withStatusDetails(e.getMessage());
            }
        }
        return i.withStatus(ServiceInstance.Status.TERMINATION_FAILED).withStatusDetails("No container id found.");
    }
}

