/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.hibernate.pagination.RowSelection;
import com.github.drinkjava2.hibernate.pagination.SQLServer2005LimitHandler;
import com.github.drinkjava2.hibernate.pagination.SQLServer2012LimitHandler;
import com.github.drinkjava2.hibernate.utils.StringHelper;
import com.github.drinkjava2.jdialects.DDLCreateUtils;
import com.github.drinkjava2.jdialects.DDLDropUtils;
import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.DialectFunctionTemplate;
import com.github.drinkjava2.jdialects.DialectLogger;
import com.github.drinkjava2.jdialects.DialectPaginationTemplate;
import com.github.drinkjava2.jdialects.DialectTypeMappingTemplate;
import com.github.drinkjava2.jdialects.FunctionUtils;
import com.github.drinkjava2.jdialects.GuessDialectUtils;
import com.github.drinkjava2.jdialects.ReservedDBWords;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.model.Table;
import com.github.drinkjava2.jdialects.tinyjdbc.TinyJdbc;
import java.sql.Connection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public enum Dialect {
    SQLiteDialect,
    AccessDialect,
    ExcelDialect,
    TextDialect,
    ParadoxDialect,
    CobolDialect,
    XMLDialect,
    DbfDialect,
    DerbyDialect,
    OracleDialect,
    Oracle9Dialect,
    Cache71Dialect,
    CUBRIDDialect,
    DerbyTenFiveDialect,
    DataDirectOracle9Dialect,
    DB2Dialect,
    DB2390Dialect,
    DB2400Dialect,
    DerbyTenSevenDialect,
    DerbyTenSixDialect,
    FirebirdDialect,
    FrontBaseDialect,
    H2Dialect,
    HANAColumnStoreDialect,
    HANARowStoreDialect,
    HSQLDialect,
    InformixDialect,
    Informix10Dialect,
    IngresDialect,
    Ingres10Dialect,
    Ingres9Dialect,
    InterbaseDialect,
    JDataStoreDialect,
    MariaDBDialect,
    MariaDB53Dialect,
    MckoiDialect,
    MimerSQLDialect,
    MySQLDialect,
    MySQL5Dialect,
    MySQL55Dialect,
    MySQL57Dialect,
    MySQL57InnoDBDialect,
    MySQL5InnoDBDialect,
    MySQLInnoDBDialect,
    MySQLMyISAMDialect,
    Oracle8iDialect,
    Oracle9iDialect,
    Oracle10gDialect,
    Oracle12cDialect,
    PointbaseDialect,
    PostgresPlusDialect,
    PostgreSQLDialect,
    PostgreSQL81Dialect,
    PostgreSQL82Dialect,
    PostgreSQL9Dialect,
    PostgreSQL91Dialect,
    PostgreSQL92Dialect,
    PostgreSQL93Dialect,
    PostgreSQL94Dialect,
    PostgreSQL95Dialect,
    ProgressDialect,
    RDMSOS2200Dialect,
    SAPDBDialect,
    SQLServerDialect,
    SQLServer2005Dialect,
    SQLServer2008Dialect,
    SQLServer2012Dialect,
    SybaseDialect,
    Sybase11Dialect,
    SybaseAnywhereDialect,
    SybaseASE15Dialect,
    SybaseASE157Dialect,
    TeradataDialect,
    Teradata14Dialect,
    TimesTenDialect;

    private static final String SKIP_ROWS = "$SKIP_ROWS";
    private static final String PAGESIZE = "$PAGESIZE";
    private static final String TOTAL_ROWS = "$TOTAL_ROWS";
    private static final String SKIP_ROWS_PLUS1 = "$SKIP_ROWS_PLUS1";
    private static final String TOTAL_ROWS_PLUS1 = "$TOTAL_ROWS_PLUS1";
    private static final String DISTINCT_TAG = "($DISTINCT)";
    public static final String NOT_SUPPORT = "NOT_SUPPORT";
    private static DialectLogger logger;
    private String sqlTemplate = null;
    private String topLimitTemplate = null;
    protected final Map<Type, String> typeMappings = new EnumMap<Type, String>(Type.class);
    protected final Map<String, String> functions = new HashMap<String, String>();
    public final DDLFeatures ddlFeatures = new DDLFeatures();

    public static Dialect guessDialect(String databaseName, Object ... majorVersionMinorVersion) {
        return GuessDialectUtils.guessDialect(databaseName, majorVersionMinorVersion);
    }

    public static Dialect guessDialect(Connection connection) {
        return GuessDialectUtils.guessDialect(connection);
    }

    public static Dialect guessDialect(DataSource datasource) {
        return GuessDialectUtils.guessDialect(datasource);
    }

    private void checkIfReservedWord(String word) {
        if (ReservedDBWords.isReservedWord(word)) {
            String reservedForDB = ReservedDBWords.reservedForDB(word);
            if (ReservedDBWords.isReservedWord(this, word)) {
                DialectException.throwEX("\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table or column name");
            } else {
                logger.warn("\"" + word + "\" is a reserved word of other database \"" + reservedForDB + "\", not recommended to be used as table or column name");
            }
        }
    }

    public String checkReservedWords(String word) {
        this.checkIfReservedWord(word);
        return word;
    }

    public String checkNotEmptyReservedWords(String word, String ... errorMSG) {
        if (StrUtils.isEmpty(word)) {
            if (errorMSG.length == 0) {
                DialectException.throwEX("Empty value error");
            } else {
                DialectException.throwEX(errorMSG[0]);
            }
        }
        this.checkIfReservedWord(word);
        return word;
    }

    protected String translateToDDLType(Type type, Integer ... lengths) {
        String value = this.typeMappings.get((Object)type);
        if (StrUtils.isEmpty(value) || "N/A".equals(value) || "n/a".equals(value)) {
            DialectException.throwEX("Type \"" + (Object)((Object)type) + "\" is not supported by dialect \"" + (Object)((Object)this) + "\"");
        }
        if (value.contains("|")) {
            String[] mappings;
            for (String mapping : mappings = StringHelper.split("|", value)) {
                if (mapping.contains("<")) {
                    String[] limitType = StringHelper.split("<", mapping);
                    if (lengths.length <= 0 || lengths[0] >= Integer.parseInt(limitType[1])) continue;
                    return this.putParamters(type, limitType[0], lengths);
                }
                return this.putParamters(type, mapping, lengths);
            }
        } else {
            if (value.contains("$")) {
                return this.putParamters(type, value, lengths);
            }
            return value;
        }
        return "";
    }

    public String TYPE_LONG() {
        return this.translateToDDLType(Type.BIGINT, new Integer[0]);
    }

    public String TYPE_BOOLEAN() {
        return this.translateToDDLType(Type.BOOLEAN, new Integer[0]);
    }

    public String TYPE_DOUBLE() {
        return this.translateToDDLType(Type.DOUBLE, new Integer[0]);
    }

    public String TYPE_FLOAT(Integer ... lengths) {
        return this.translateToDDLType(Type.FLOAT, lengths);
    }

    public String TYPE_INTEGER() {
        return this.translateToDDLType(Type.INTEGER, new Integer[0]);
    }

    public String TYPE_SHORT() {
        return this.translateToDDLType(Type.SMALLINT, new Integer[0]);
    }

    public String TYPE_BIGDECIMAL(Integer precision, Integer scale) {
        return this.translateToDDLType(Type.NUMERIC, precision, scale);
    }

    public String TYPE_STRING(Integer length) {
        return this.translateToDDLType(Type.VARCHAR, length);
    }

    public String TYPE_DATE() {
        return this.translateToDDLType(Type.DATE, new Integer[0]);
    }

    public String TYPE_TIME() {
        return this.translateToDDLType(Type.TIME, new Integer[0]);
    }

    public String TYPE_TIMESTAMP() {
        return this.translateToDDLType(Type.TIMESTAMP, new Integer[0]);
    }

    public String TYPE_BIGINT() {
        return this.translateToDDLType(Type.BIGINT, new Integer[0]);
    }

    public String TYPE_BINARY(Integer ... lengths) {
        return this.translateToDDLType(Type.BINARY, lengths);
    }

    public String TYPE_BIT() {
        return this.translateToDDLType(Type.BIT, new Integer[0]);
    }

    public String TYPE_BLOB(Integer ... lengths) {
        return this.translateToDDLType(Type.BLOB, lengths);
    }

    public String TYPE_CHAR(Integer ... lengths) {
        return this.translateToDDLType(Type.CHAR, lengths);
    }

    public String TYPE_CLOB(Integer ... lengths) {
        return this.translateToDDLType(Type.CLOB, lengths);
    }

    public String TYPE_DECIMAL(Integer ... lengths) {
        return this.translateToDDLType(Type.DECIMAL, lengths);
    }

    public String TYPE_JAVA_OBJECT() {
        return this.translateToDDLType(Type.JAVA_OBJECT, new Integer[0]);
    }

    public String TYPE_LONGNVARCHAR(Integer length) {
        return this.translateToDDLType(Type.LONGNVARCHAR, length);
    }

    public String TYPE_LONGVARBINARY(Integer ... lengths) {
        return this.translateToDDLType(Type.LONGVARBINARY, lengths);
    }

    public String TYPE_LONGVARCHAR(Integer ... lengths) {
        return this.translateToDDLType(Type.LONGVARCHAR, lengths);
    }

    public String TYPE_NCHAR(Integer length) {
        return this.translateToDDLType(Type.NCHAR, length);
    }

    public String TYPE_NCLOB() {
        return this.translateToDDLType(Type.NCLOB, new Integer[0]);
    }

    public String TYPE_NUMERIC(Integer ... lengths) {
        return this.translateToDDLType(Type.NUMERIC, lengths);
    }

    public String TYPE_NVARCHAR(Integer length) {
        return this.translateToDDLType(Type.NVARCHAR, length);
    }

    public String TYPE_OTHER(Integer ... lengths) {
        return this.translateToDDLType(Type.OTHER, lengths);
    }

    public String TYPE_REAL() {
        return this.translateToDDLType(Type.REAL, new Integer[0]);
    }

    public String TYPE_SMALLINT() {
        return this.translateToDDLType(Type.SMALLINT, new Integer[0]);
    }

    public String TYPE_TINYINT() {
        return this.translateToDDLType(Type.TINYINT, new Integer[0]);
    }

    public String TYPE_VARBINARY(Integer ... lengths) {
        return this.translateToDDLType(Type.VARBINARY, lengths);
    }

    public String TYPE_VARCHAR(Integer length) {
        return this.translateToDDLType(Type.VARCHAR, length);
    }

    public String fn_ABS(Object ... args) {
        return FunctionUtils.render(this, "abs", args);
    }

    public String fn_AVG(Object ... args) {
        return FunctionUtils.render(this, "avg", args);
    }

    public String fn_BIT_LENGTH(Object ... args) {
        return FunctionUtils.render(this, "bit_length", args);
    }

    public String fn_CAST(Object ... args) {
        return FunctionUtils.render(this, "cast", args);
    }

    public String fn_COALESCE(Object ... args) {
        return FunctionUtils.render(this, "coalesce", args);
    }

    public String fn_COUNT(Object ... args) {
        return FunctionUtils.render(this, "count", args);
    }

    public String fn_DAY(Object ... args) {
        return FunctionUtils.render(this, "day", args);
    }

    public String fn_EXTRACT(Object ... args) {
        return FunctionUtils.render(this, "extract", args);
    }

    public String fn_HOUR(Object ... args) {
        return FunctionUtils.render(this, "hour", args);
    }

    public String fn_LENGTH(Object ... args) {
        return FunctionUtils.render(this, "length", args);
    }

    public String fn_LOCATE(Object ... args) {
        return FunctionUtils.render(this, "locate", args);
    }

    public String fn_LOWER(Object ... args) {
        return FunctionUtils.render(this, "lower", args);
    }

    public String fn_MAX(Object ... args) {
        return FunctionUtils.render(this, "max", args);
    }

    public String fn_MIN(Object ... args) {
        return FunctionUtils.render(this, "min", args);
    }

    public String fn_MINUTE(Object ... args) {
        return FunctionUtils.render(this, "minute", args);
    }

    public String fn_MOD(Object ... args) {
        return FunctionUtils.render(this, "mod", args);
    }

    public String fn_MONTH(Object ... args) {
        return FunctionUtils.render(this, "month", args);
    }

    public String fn_NULLIF(Object ... args) {
        return FunctionUtils.render(this, "nullif", args);
    }

    public String fn_SECOND(Object ... args) {
        return FunctionUtils.render(this, "second", args);
    }

    public String fn_SQRT(Object ... args) {
        return FunctionUtils.render(this, "sqrt", args);
    }

    public String fn_STR(Object ... args) {
        return FunctionUtils.render(this, "str", args);
    }

    public String fn_SUBSTRING(Object ... args) {
        return FunctionUtils.render(this, "substring", args);
    }

    public String fn_SUM(Object ... args) {
        return FunctionUtils.render(this, "sum", args);
    }

    public String fn_TRIM(Object ... args) {
        return FunctionUtils.render(this, "trim", args);
    }

    public String fn_UPPER(Object ... args) {
        return FunctionUtils.render(this, "upper", args);
    }

    public String fn_YEAR(Object ... args) {
        return FunctionUtils.render(this, "year", args);
    }

    public String fn_concat(Object ... args) {
        return FunctionUtils.render(this, "concat", args);
    }

    public String fn_cos(Object ... args) {
        return FunctionUtils.render(this, "cos", args);
    }

    public String fn_exp(Object ... args) {
        return FunctionUtils.render(this, "exp", args);
    }

    public String fn_sin(Object ... args) {
        return FunctionUtils.render(this, "sin", args);
    }

    public String fn_log(Object ... args) {
        return FunctionUtils.render(this, "log", args);
    }

    public String fn_round(Object ... args) {
        return FunctionUtils.render(this, "round", args);
    }

    public String fn_atan(Object ... args) {
        return FunctionUtils.render(this, "atan", args);
    }

    public String fn_sign(Object ... args) {
        return FunctionUtils.render(this, "sign", args);
    }

    public String fn_acos(Object ... args) {
        return FunctionUtils.render(this, "acos", args);
    }

    public String fn_asin(Object ... args) {
        return FunctionUtils.render(this, "asin", args);
    }

    public String fn_current_date(Object ... args) {
        return FunctionUtils.render(this, "current_date", args);
    }

    public String fn_floor(Object ... args) {
        return FunctionUtils.render(this, "floor", args);
    }

    public String fn_tan(Object ... args) {
        return FunctionUtils.render(this, "tan", args);
    }

    public String fn_current_timestamp(Object ... args) {
        return FunctionUtils.render(this, "current_timestamp", args);
    }

    public String fn_current_time(Object ... args) {
        return FunctionUtils.render(this, "current_time", args);
    }

    public String fn_cot(Object ... args) {
        return FunctionUtils.render(this, "cot", args);
    }

    public String fn_ascii(Object ... args) {
        return FunctionUtils.render(this, "ascii", args);
    }

    public String fn_rtrim(Object ... args) {
        return FunctionUtils.render(this, "rtrim", args);
    }

    public String fn_ln(Object ... args) {
        return FunctionUtils.render(this, "ln", args);
    }

    public String fn_ltrim(Object ... args) {
        return FunctionUtils.render(this, "ltrim", args);
    }

    public String fn_degrees(Object ... args) {
        return FunctionUtils.render(this, "degrees", args);
    }

    public String fn_radians(Object ... args) {
        return FunctionUtils.render(this, "radians", args);
    }

    public String fn_rand(Object ... args) {
        return FunctionUtils.render(this, "rand", args);
    }

    public String fn_ceil(Object ... args) {
        return FunctionUtils.render(this, "ceil", args);
    }

    public String fn_soundex(Object ... args) {
        return FunctionUtils.render(this, "soundex", args);
    }

    public String fn_user(Object ... args) {
        return FunctionUtils.render(this, "user", args);
    }

    public String fn_log10(Object ... args) {
        return FunctionUtils.render(this, "log10", args);
    }

    public String fn_substr(Object ... args) {
        return FunctionUtils.render(this, "substr", args);
    }

    public String fn_ceiling(Object ... args) {
        return FunctionUtils.render(this, "ceiling", args);
    }

    public String fn_stddev(Object ... args) {
        return FunctionUtils.render(this, "stddev", args);
    }

    public String fn_now(Object ... args) {
        return FunctionUtils.render(this, "now", args);
    }

    public String fn_char_length(Object ... args) {
        return FunctionUtils.render(this, "char_length", args);
    }

    public String fn_chr(Object ... args) {
        return FunctionUtils.render(this, "chr", args);
    }

    public String fn_dayofyear(Object ... args) {
        return FunctionUtils.render(this, "dayofyear", args);
    }

    public String fn_octet_length(Object ... args) {
        return FunctionUtils.render(this, "octet_length", args);
    }

    public String fn_pi(Object ... args) {
        return FunctionUtils.render(this, "pi", args);
    }

    public String fn_week(Object ... args) {
        return FunctionUtils.render(this, "week", args);
    }

    public String fn_dayname(Object ... args) {
        return FunctionUtils.render(this, "dayname", args);
    }

    public String fn_dayofweek(Object ... args) {
        return FunctionUtils.render(this, "dayofweek", args);
    }

    public String fn_lcase(Object ... args) {
        return FunctionUtils.render(this, "lcase", args);
    }

    public String fn_monthname(Object ... args) {
        return FunctionUtils.render(this, "monthname", args);
    }

    public String fn_quarter(Object ... args) {
        return FunctionUtils.render(this, "quarter", args);
    }

    public String fn_space(Object ... args) {
        return FunctionUtils.render(this, "space", args);
    }

    public String fn_sysdate(Object ... args) {
        return FunctionUtils.render(this, "sysdate", args);
    }

    public String fn_ucase(Object ... args) {
        return FunctionUtils.render(this, "ucase", args);
    }

    public String fn_char(Object ... args) {
        return FunctionUtils.render(this, "char", args);
    }

    public String fn_reverse(Object ... args) {
        return FunctionUtils.render(this, "reverse", args);
    }

    public String fn_hex(Object ... args) {
        return FunctionUtils.render(this, "hex", args);
    }

    public String fn_last_day(Object ... args) {
        return FunctionUtils.render(this, "last_day", args);
    }

    public String fn_md5(Object ... args) {
        return FunctionUtils.render(this, "md5", args);
    }

    public String fn_time(Object ... args) {
        return FunctionUtils.render(this, "time", args);
    }

    public String fn_timestamp(Object ... args) {
        return FunctionUtils.render(this, "timestamp", args);
    }

    public String fn_date(Object ... args) {
        return FunctionUtils.render(this, "date", args);
    }

    public String fn_trunc(Object ... args) {
        return FunctionUtils.render(this, "trunc", args);
    }

    public String fn_variance(Object ... args) {
        return FunctionUtils.render(this, "variance", args);
    }

    public String fn_initcap(Object ... args) {
        return FunctionUtils.render(this, "initcap", args);
    }

    public String fn_power(Object ... args) {
        return FunctionUtils.render(this, "power", args);
    }

    public String fn_dayofmonth(Object ... args) {
        return FunctionUtils.render(this, "dayofmonth", args);
    }

    public String fn_atan2(Object ... args) {
        return FunctionUtils.render(this, "atan2", args);
    }

    public String fn_character_length(Object ... args) {
        return FunctionUtils.render(this, "character_length", args);
    }

    public String fn_curdate(Object ... args) {
        return FunctionUtils.render(this, "curdate", args);
    }

    public String fn_curtime(Object ... args) {
        return FunctionUtils.render(this, "curtime", args);
    }

    public String fn_datediff(Object ... args) {
        return FunctionUtils.render(this, "datediff", args);
    }

    public String fn_replace(Object ... args) {
        return FunctionUtils.render(this, "replace", args);
    }

    public String fn_to_date(Object ... args) {
        return FunctionUtils.render(this, "to_date", args);
    }

    public String fn_localtime(Object ... args) {
        return FunctionUtils.render(this, "localtime", args);
    }

    public String fn_localtimestamp(Object ... args) {
        return FunctionUtils.render(this, "localtimestamp", args);
    }

    public String fn_nvl(Object ... args) {
        return FunctionUtils.render(this, "nvl", args);
    }

    public String fn_to_char(Object ... args) {
        return FunctionUtils.render(this, "to_char", args);
    }

    public String fn_lpad(Object ... args) {
        return FunctionUtils.render(this, "lpad", args);
    }

    public String fn_rpad(Object ... args) {
        return FunctionUtils.render(this, "rpad", args);
    }

    public String fn_bin(Object ... args) {
        return FunctionUtils.render(this, "bin", args);
    }

    public String fn_encrypt(Object ... args) {
        return FunctionUtils.render(this, "encrypt", args);
    }

    public String fn_from_days(Object ... args) {
        return FunctionUtils.render(this, "from_days", args);
    }

    public String fn_log2(Object ... args) {
        return FunctionUtils.render(this, "log2", args);
    }

    public String fn_timediff(Object ... args) {
        return FunctionUtils.render(this, "timediff", args);
    }

    public String fn_to_days(Object ... args) {
        return FunctionUtils.render(this, "to_days", args);
    }

    public String fn_weekofyear(Object ... args) {
        return FunctionUtils.render(this, "weekofyear", args);
    }

    public String fn_crc32(Object ... args) {
        return FunctionUtils.render(this, "crc32", args);
    }

    public String fn_instr(Object ... args) {
        return FunctionUtils.render(this, "instr", args);
    }

    public String fn_isnull(Object ... args) {
        return FunctionUtils.render(this, "isnull", args);
    }

    public String fn_len(Object ... args) {
        return FunctionUtils.render(this, "len", args);
    }

    public String fn_oct(Object ... args) {
        return FunctionUtils.render(this, "oct", args);
    }

    public String fn_translate(Object ... args) {
        return FunctionUtils.render(this, "translate", args);
    }

    public String fn_microsecond(Object ... args) {
        return FunctionUtils.render(this, "microsecond", args);
    }

    public String fn_right(Object ... args) {
        return FunctionUtils.render(this, "right", args);
    }

    public String fn_current_user(Object ... args) {
        return FunctionUtils.render(this, "current_user", args);
    }

    public String fn_random(Object ... args) {
        return FunctionUtils.render(this, "random", args);
    }

    public String fn_session_user(Object ... args) {
        return FunctionUtils.render(this, "session_user", args);
    }

    public String fn_left(Object ... args) {
        return FunctionUtils.render(this, "left", args);
    }

    public String fn_date_trunc(Object ... args) {
        return FunctionUtils.render(this, "date_trunc", args);
    }

    public String fn_unhex(Object ... args) {
        return FunctionUtils.render(this, "unhex", args);
    }

    public String fn_weekday(Object ... args) {
        return FunctionUtils.render(this, "weekday", args);
    }

    public String fn_current_schema(Object ... args) {
        return FunctionUtils.render(this, "current_schema", args);
    }

    public String fn_position(Object ... args) {
        return FunctionUtils.render(this, "position", args);
    }

    public String fn_to_timestamp(Object ... args) {
        return FunctionUtils.render(this, "to_timestamp", args);
    }

    public String fn_add_months(Object ... args) {
        return FunctionUtils.render(this, "add_months", args);
    }

    public String fn_bit_count(Object ... args) {
        return FunctionUtils.render(this, "bit_count", args);
    }

    public String fn_cosh(Object ... args) {
        return FunctionUtils.render(this, "cosh", args);
    }

    public String fn_from_unixtime(Object ... args) {
        return FunctionUtils.render(this, "from_unixtime", args);
    }

    public String fn_getdate(Object ... args) {
        return FunctionUtils.render(this, "getdate", args);
    }

    public String fn_quote(Object ... args) {
        return FunctionUtils.render(this, "quote", args);
    }

    public String fn_sec_to_time(Object ... args) {
        return FunctionUtils.render(this, "sec_to_time", args);
    }

    public String fn_sinh(Object ... args) {
        return FunctionUtils.render(this, "sinh", args);
    }

    public String fn_tanh(Object ... args) {
        return FunctionUtils.render(this, "tanh", args);
    }

    public String fn_time_to_sec(Object ... args) {
        return FunctionUtils.render(this, "time_to_sec", args);
    }

    public String fn_to_number(Object ... args) {
        return FunctionUtils.render(this, "to_number", args);
    }

    public String fn_unix_timestamp(Object ... args) {
        return FunctionUtils.render(this, "unix_timestamp", args);
    }

    public String fn_utc_date(Object ... args) {
        return FunctionUtils.render(this, "utc_date", args);
    }

    public String fn_utc_time(Object ... args) {
        return FunctionUtils.render(this, "utc_time", args);
    }

    public String fn_age(Object ... args) {
        return FunctionUtils.render(this, "age", args);
    }

    public String fn_cbrt(Object ... args) {
        return FunctionUtils.render(this, "cbrt", args);
    }

    public String fn_current_database(Object ... args) {
        return FunctionUtils.render(this, "current_database", args);
    }

    public String fn_database(Object ... args) {
        return FunctionUtils.render(this, "database", args);
    }

    public String fn_datename(Object ... args) {
        return FunctionUtils.render(this, "datename", args);
    }

    public String fn_date_format(Object ... args) {
        return FunctionUtils.render(this, "date_format", args);
    }

    public String fn_difference(Object ... args) {
        return FunctionUtils.render(this, "difference", args);
    }

    public String fn_dow(Object ... args) {
        return FunctionUtils.render(this, "dow", args);
    }

    public String fn_ifnull(Object ... args) {
        return FunctionUtils.render(this, "ifnull", args);
    }

    public String fn_microseconds(Object ... args) {
        return FunctionUtils.render(this, "microseconds", args);
    }

    public String fn_next_day(Object ... args) {
        return FunctionUtils.render(this, "next_day", args);
    }

    public String fn_ord(Object ... args) {
        return FunctionUtils.render(this, "ord", args);
    }

    public String fn_quote_ident(Object ... args) {
        return FunctionUtils.render(this, "quote_ident", args);
    }

    public String fn_quote_literal(Object ... args) {
        return FunctionUtils.render(this, "quote_literal", args);
    }

    public String fn_replicate(Object ... args) {
        return FunctionUtils.render(this, "replicate", args);
    }

    public String fn_sha(Object ... args) {
        return FunctionUtils.render(this, "sha", args);
    }

    public String fn_sha1(Object ... args) {
        return FunctionUtils.render(this, "sha1", args);
    }

    public String fn_timeofday(Object ... args) {
        return FunctionUtils.render(this, "timeofday", args);
    }

    public String fn_to_ascii(Object ... args) {
        return FunctionUtils.render(this, "to_ascii", args);
    }

    public String fn_truncate(Object ... args) {
        return FunctionUtils.render(this, "truncate", args);
    }

    public String fn_utc_timestamp(Object ... args) {
        return FunctionUtils.render(this, "utc_timestamp", args);
    }

    public String fn_yearweek(Object ... args) {
        return FunctionUtils.render(this, "yearweek", args);
    }

    public String fn_datetime(Object ... args) {
        return FunctionUtils.render(this, "datetime", args);
    }

    public String fn_getutcdate(Object ... args) {
        return FunctionUtils.render(this, "getutcdate", args);
    }

    public String fn_months_between(Object ... args) {
        return FunctionUtils.render(this, "months_between", args);
    }

    public String fn_nvl2(Object ... args) {
        return FunctionUtils.render(this, "nvl2", args);
    }

    public String fn_repeat(Object ... args) {
        return FunctionUtils.render(this, "repeat", args);
    }

    public String fn_rownum(Object ... args) {
        return FunctionUtils.render(this, "rownum", args);
    }

    public String fn_square(Object ... args) {
        return FunctionUtils.render(this, "square", args);
    }

    public String fn_stuff(Object ... args) {
        return FunctionUtils.render(this, "stuff", args);
    }

    public String fn_bigint(Object ... args) {
        return FunctionUtils.render(this, "bigint", args);
    }

    public String fn_compress(Object ... args) {
        return FunctionUtils.render(this, "compress", args);
    }

    public String fn_days(Object ... args) {
        return FunctionUtils.render(this, "days", args);
    }

    public String fn_decrypt(Object ... args) {
        return FunctionUtils.render(this, "decrypt", args);
    }

    public String fn_instrb(Object ... args) {
        return FunctionUtils.render(this, "instrb", args);
    }

    public String fn_integer(Object ... args) {
        return FunctionUtils.render(this, "integer", args);
    }

    public String fn_real(Object ... args) {
        return FunctionUtils.render(this, "real", args);
    }

    public String fn_rowid(Object ... args) {
        return FunctionUtils.render(this, "rowid", args);
    }

    public String fn_smallint(Object ... args) {
        return FunctionUtils.render(this, "smallint", args);
    }

    public String fn_systimestamp(Object ... args) {
        return FunctionUtils.render(this, "systimestamp", args);
    }

    public String fn_timestampadd(Object ... args) {
        return FunctionUtils.render(this, "timestampadd", args);
    }

    public String fn_timestampdiff(Object ... args) {
        return FunctionUtils.render(this, "timestampdiff", args);
    }

    public String fn_varchar(Object ... args) {
        return FunctionUtils.render(this, "varchar", args);
    }

    public String fn_absval(Object ... args) {
        return FunctionUtils.render(this, "absval", args);
    }

    public String fn_adddate(Object ... args) {
        return FunctionUtils.render(this, "adddate", args);
    }

    public String fn_addtime(Object ... args) {
        return FunctionUtils.render(this, "addtime", args);
    }

    public String fn_alltrim(Object ... args) {
        return FunctionUtils.render(this, "alltrim", args);
    }

    public String fn_asc(Object ... args) {
        return FunctionUtils.render(this, "asc", args);
    }

    public String fn_at(Object ... args) {
        return FunctionUtils.render(this, "at", args);
    }

    public String fn_bitand(Object ... args) {
        return FunctionUtils.render(this, "bitand", args);
    }

    public String fn_cbool(Object ... args) {
        return FunctionUtils.render(this, "cbool", args);
    }

    public String fn_cbyte(Object ... args) {
        return FunctionUtils.render(this, "cbyte", args);
    }

    public String fn_cdate(Object ... args) {
        return FunctionUtils.render(this, "cdate", args);
    }

    public String fn_cdbl(Object ... args) {
        return FunctionUtils.render(this, "cdbl", args);
    }

    public String fn_cdow(Object ... args) {
        return FunctionUtils.render(this, "cdow", args);
    }

    public String fn_charmirr(Object ... args) {
        return FunctionUtils.render(this, "charmirr", args);
    }

    public String fn_chrtran(Object ... args) {
        return FunctionUtils.render(this, "chrtran", args);
    }

    public String fn_cint(Object ... args) {
        return FunctionUtils.render(this, "cint", args);
    }

    public String fn_clng(Object ... args) {
        return FunctionUtils.render(this, "clng", args);
    }

    public String fn_cmonth(Object ... args) {
        return FunctionUtils.render(this, "cmonth", args);
    }

    public String fn_concat_ws(Object ... args) {
        return FunctionUtils.render(this, "concat_ws", args);
    }

    public String fn_conv(Object ... args) {
        return FunctionUtils.render(this, "conv", args);
    }

    public String fn_crypt3(Object ... args) {
        return FunctionUtils.render(this, "crypt3", args);
    }

    public String fn_csng(Object ... args) {
        return FunctionUtils.render(this, "csng", args);
    }

    public String fn_cstr(Object ... args) {
        return FunctionUtils.render(this, "cstr", args);
    }

    public String fn_ctod(Object ... args) {
        return FunctionUtils.render(this, "ctod", args);
    }

    public String fn_ctot(Object ... args) {
        return FunctionUtils.render(this, "ctot", args);
    }

    public String fn_date_add(Object ... args) {
        return FunctionUtils.render(this, "date_add", args);
    }

    public String fn_date_sub(Object ... args) {
        return FunctionUtils.render(this, "date_sub", args);
    }

    public String fn_dayofweek_iso(Object ... args) {
        return FunctionUtils.render(this, "dayofweek_iso", args);
    }

    public String fn_decode(Object ... args) {
        return FunctionUtils.render(this, "decode", args);
    }

    public String fn_deleted(Object ... args) {
        return FunctionUtils.render(this, "deleted", args);
    }

    public String fn_digits(Object ... args) {
        return FunctionUtils.render(this, "digits", args);
    }

    public String fn_double(Object ... args) {
        return FunctionUtils.render(this, "double", args);
    }

    public String fn_dtoc(Object ... args) {
        return FunctionUtils.render(this, "dtoc", args);
    }

    public String fn_dtot(Object ... args) {
        return FunctionUtils.render(this, "dtot", args);
    }

    public String fn_empty(Object ... args) {
        return FunctionUtils.render(this, "empty", args);
    }

    public String fn_encode(Object ... args) {
        return FunctionUtils.render(this, "encode", args);
    }

    public String fn_float(Object ... args) {
        return FunctionUtils.render(this, "float", args);
    }

    public String fn_gomonth(Object ... args) {
        return FunctionUtils.render(this, "gomonth", args);
    }

    public String fn_int(Object ... args) {
        return FunctionUtils.render(this, "int", args);
    }

    public String fn_isalpha(Object ... args) {
        return FunctionUtils.render(this, "isalpha", args);
    }

    public String fn_isblank(Object ... args) {
        return FunctionUtils.render(this, "isblank", args);
    }

    public String fn_isdigit(Object ... args) {
        return FunctionUtils.render(this, "isdigit", args);
    }

    public String fn_julian_day(Object ... args) {
        return FunctionUtils.render(this, "julian_day", args);
    }

    public String fn_mid(Object ... args) {
        return FunctionUtils.render(this, "mid", args);
    }

    public String fn_midnight_seconds(Object ... args) {
        return FunctionUtils.render(this, "midnight_seconds", args);
    }

    public String fn_millisecond(Object ... args) {
        return FunctionUtils.render(this, "millisecond", args);
    }

    public String fn_padc(Object ... args) {
        return FunctionUtils.render(this, "padc", args);
    }

    public String fn_padians(Object ... args) {
        return FunctionUtils.render(this, "padians", args);
    }

    public String fn_padl(Object ... args) {
        return FunctionUtils.render(this, "padl", args);
    }

    public String fn_padr(Object ... args) {
        return FunctionUtils.render(this, "padr", args);
    }

    public String fn_posstr(Object ... args) {
        return FunctionUtils.render(this, "posstr", args);
    }

    public String fn_pow(Object ... args) {
        return FunctionUtils.render(this, "pow", args);
    }

    public String fn_proper(Object ... args) {
        return FunctionUtils.render(this, "proper", args);
    }

    public String fn_reccount(Object ... args) {
        return FunctionUtils.render(this, "reccount", args);
    }

    public String fn_recno(Object ... args) {
        return FunctionUtils.render(this, "recno", args);
    }

    public String fn_rowlocked(Object ... args) {
        return FunctionUtils.render(this, "rowlocked", args);
    }

    public String fn_strcat(Object ... args) {
        return FunctionUtils.render(this, "strcat", args);
    }

    public String fn_strcmp(Object ... args) {
        return FunctionUtils.render(this, "strcmp", args);
    }

    public String fn_strconv(Object ... args) {
        return FunctionUtils.render(this, "strconv", args);
    }

    public String fn_strtran(Object ... args) {
        return FunctionUtils.render(this, "strtran", args);
    }

    public String fn_subdate(Object ... args) {
        return FunctionUtils.render(this, "subdate", args);
    }

    public String fn_substrb(Object ... args) {
        return FunctionUtils.render(this, "substrb", args);
    }

    public String fn_sub_time(Object ... args) {
        return FunctionUtils.render(this, "sub_time", args);
    }

    public String fn_timestamp_iso(Object ... args) {
        return FunctionUtils.render(this, "timestamp_iso", args);
    }

    public String fn_ttoc(Object ... args) {
        return FunctionUtils.render(this, "ttoc", args);
    }

    public String fn_ttod(Object ... args) {
        return FunctionUtils.render(this, "ttod", args);
    }

    public String fn_uid(Object ... args) {
        return FunctionUtils.render(this, "uid", args);
    }

    public String fn_uncompress(Object ... args) {
        return FunctionUtils.render(this, "uncompress", args);
    }

    public String fn_week_iso(Object ... args) {
        return FunctionUtils.render(this, "week_iso", args);
    }

    private String putParamters(Type type, String value, Integer ... lengths) {
        if (lengths.length < StrUtils.countMatches(value, '$')) {
            DialectException.throwEX("In Dialect \"" + (Object)((Object)this) + "\", Type \"" + (Object)((Object)type) + "\" should have " + StrUtils.countMatches(value, '$') + " parameters");
        }
        int i = 0;
        String newValue = value;
        if (newValue.contains("$l")) {
            newValue = StrUtils.replace(newValue, "$l", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$p")) {
            newValue = StrUtils.replace(newValue, "$p", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$s")) {
            newValue = StrUtils.replace(newValue, "$s", String.valueOf(lengths[i]));
        }
        return newValue;
    }

    private static String aTopLimitSqlExample(String template) {
        String result = StrUtils.replaceIgnoreCase(template, "$SQL", "select * from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, "$BODY", "* from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, " ($DISTINCT)", "");
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS, "0");
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, "10");
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, "10");
        return result;
    }

    private static String processSQLServer(Dialect dialect, int pageNumber, int pageSize, String sql) {
        int skipRows = (pageNumber - 1) * pageSize;
        int totalRows = pageNumber * pageSize;
        RowSelection selection = new RowSelection(skipRows, totalRows);
        String result = null;
        switch (dialect) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: {
                result = new SQLServer2005LimitHandler().processSql(sql, selection);
                break;
            }
            case SQLServer2012Dialect: {
                result = new SQLServer2012LimitHandler().processSql(sql, selection);
                break;
            }
        }
        result = StringHelper.replace(result, "__hibernate_row_nr__", "_ROW_NUM_");
        result = StringHelper.replaceOnce(result, " $Top_Tag(?) ", " TOP(" + totalRows + ") ");
        result = StringHelper.replaceOnce(result, "_ROW_NUM_ >= ? AND _ROW_NUM_ < ?", "_ROW_NUM_ >= " + (skipRows + 1) + " AND _ROW_NUM_ < " + (totalRows + 1));
        result = StringHelper.replaceOnce(result, "offset ? rows fetch next ? rows only", "offset " + skipRows + " rows fetch next " + pageSize + " rows only");
        result = StringHelper.replaceOnce(result, "offset 0 rows fetch next ? rows only", "offset 0 rows fetch next " + pageSize + " rows only");
        if (StrUtils.isEmpty(result)) {
            return (String)DialectException.throwEX("Unexpected error, please report this bug");
        }
        return result;
    }

    public String paginate(int pageNumber, int pageSize, String sql) {
        DialectException.assureNotNull(sql, "sql string can not be null");
        String trimedSql = sql.trim();
        DialectException.assureNotEmpty(trimedSql, "sql string can not be empty");
        switch (this) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: 
            case SQLServer2012Dialect: {
                return Dialect.processSQLServer(this, pageNumber, pageSize, trimedSql);
            }
        }
        if (!StrUtils.startsWithIgnoreCase(trimedSql, "select ")) {
            return (String)DialectException.throwEX("SQL should start with \"select \".");
        }
        String body = trimedSql.substring(7).trim();
        DialectException.assureNotEmpty(body, "SQL body can not be empty");
        int skipRows = (pageNumber - 1) * pageSize;
        int skipRowsPlus1 = skipRows + 1;
        int totalRows = pageNumber * pageSize;
        int totalRowsPlus1 = totalRows + 1;
        String useTemplate = this.sqlTemplate;
        if (skipRows == 0) {
            useTemplate = this.topLimitTemplate;
        }
        if (NOT_SUPPORT.equals(useTemplate)) {
            if (!NOT_SUPPORT.equals(this.topLimitTemplate)) {
                return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" only support top limit SQL, for example: \"" + Dialect.aTopLimitSqlExample(this.topLimitTemplate) + "\"");
            }
            return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" does not support physical pagination");
        }
        if (useTemplate.contains(DISTINCT_TAG)) {
            if (!StrUtils.startsWithIgnoreCase(body, "distinct ")) {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "");
            } else {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "distinct");
                body = body.substring(9);
            }
        }
        String result = StrUtils.replaceIgnoreCase(useTemplate, SKIP_ROWS, String.valueOf(skipRows));
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, String.valueOf(pageSize));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, String.valueOf(totalRows));
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS_PLUS1, String.valueOf(skipRowsPlus1));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS_PLUS1, String.valueOf(totalRowsPlus1));
        result = StrUtils.replace(result, "$SQL", trimedSql);
        result = StrUtils.replace(result, "$BODY", body);
        return result;
    }

    public boolean isMySqlFamily() {
        return this.toString().startsWith("MySQL");
    }

    public boolean isInfomixFamily() {
        return this.toString().startsWith("Infomix");
    }

    public boolean isOracleFamily() {
        return this.toString().startsWith("Oracle");
    }

    public boolean isSQLServerFamily() {
        return this.toString().startsWith("SQLServer");
    }

    public boolean isH2Family() {
        return H2Dialect.equals((Object)this);
    }

    public boolean isPostgresFamily() {
        return this.toString().startsWith("Postgres");
    }

    public boolean isSybaseFamily() {
        return this.toString().startsWith("Sybase");
    }

    public boolean isDB2Family() {
        return this.toString().startsWith("DB2");
    }

    public boolean isDerbyFamily() {
        return this.toString().startsWith("Derby");
    }

    public String[] toCreateDDL(Table ... tables) {
        return DDLCreateUtils.toCreateDDL(this, tables);
    }

    public String[] toDropDDL(Table ... tables) {
        return DDLDropUtils.toDropDDL(this, tables);
    }

    public String[] toDropAndCreateDDL(Table ... tables) {
        String[] drop = DDLDropUtils.toDropDDL(this, tables);
        String[] create = DDLCreateUtils.toCreateDDL(this, tables);
        return StrUtils.joinStringArray(drop, create);
    }

    public String dropTableDDL(String tableName) {
        return this.ddlFeatures.dropTableString.replaceFirst("_TABLENAME", tableName);
    }

    public String dropSequenceDDL(String sequenceName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropSequenceStrings)) {
            return StrUtils.replace(this.ddlFeatures.dropSequenceStrings, "_SEQNAME", sequenceName);
        }
        return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" does not support drop sequence ddl, on sequence \"" + sequenceName + "\"");
    }

    public String dropFKeyDDL(String tableName, String fkeyName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropForeignKeyString)) {
            return "alter table " + tableName + " " + this.ddlFeatures.dropForeignKeyString + " " + fkeyName;
        }
        return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" does not support drop foreign key, on foreign key \"" + fkeyName + "\"");
    }

    public Long getNextAutoID(Connection connection) {
        if (this.ddlFeatures.supportBasicOrPooledSequence()) {
            String sql = StrUtils.replace(this.ddlFeatures.sequenceNextValString, "_SEQNAME", "jdialects_autoid");
            return (Long)TinyJdbc.queryForObject(connection, sql);
        }
        String sql = "update jdialects_autoid set next_val=(next_val+1)";
        int updatedCount = TinyJdbc.executeUpdate(connection, sql);
        if (updatedCount != 1) {
            DialectException.throwEX("Exception found when update jdialects_autoid table");
        }
        Long result = (Long)TinyJdbc.queryForObject(connection, "select next_val from jdialects_autoid");
        DialectException.assureNotNull(result, "Exception found when fetch Auto-Generated ID");
        return result;
    }

    static {
        logger = DialectLogger.getLog(Dialect.class);
        for (Dialect d : Dialect.values()) {
            d.sqlTemplate = DialectPaginationTemplate.initializePaginSQLTemplate(d);
            d.topLimitTemplate = DialectPaginationTemplate.initializeTopLimitSqlTemplate(d);
            DialectTypeMappingTemplate.initializeTypeMappings(d);
            DDLFeatures.initDDLFeatures(d, d.ddlFeatures);
            DialectFunctionTemplate.initFunctionTemplates1(d);
            DialectFunctionTemplate.initFunctionTemplates2(d);
            DialectFunctionTemplate.initFunctionTemplates3(d);
            DialectFunctionTemplate.initFunctionTemplates4(d);
        }
    }
}

