/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;

public class DialectConstraint {
    public static final String OPERATION_NO = "";
    public static final String OPERATION_ADD = "";
    public static final String PKEY = "PKEY";
    public static final String FKEY = "FKEY";
    public static final String INDEX = "INDEX";
    public static final String UNIQUE = "UNIQUE";
    public static final String CHECK = "CHECK";
    private String operation = "";
    private Dialect dialect;
    private String table;
    private String column;
    private String constraintName;
    private String constraintType;

    public DialectConstraint() {
    }

    public DialectConstraint(String constraintName) {
        this.constraintName = constraintName;
    }

    public DialectConstraint name(String constraintName) {
        this.constraintName = constraintName;
        return this;
    }

    public DialectConstraint type(String constraintType) {
        if (PKEY.equalsIgnoreCase(constraintType) || FKEY.equalsIgnoreCase(constraintType) || INDEX.equalsIgnoreCase(constraintType) || UNIQUE.equalsIgnoreCase(constraintType) || CHECK.equalsIgnoreCase(constraintType)) {
            this.constraintType = constraintType;
        } else {
            DialectException.throwEX("ConstraintType can only be one of:\"PKEY\", \"FKEY\",\"INDEX\",\"UNIQUE\",\"CHECK\",");
        }
        return this;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public DialectConstraint setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public String getConstraintType() {
        return this.constraintType;
    }

    public String getOperation() {
        return this.operation;
    }

    public DialectConstraint setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public DialectConstraint setTable(String table) {
        this.table = table;
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public DialectConstraint setColumn(String column) {
        this.column = column;
        return this;
    }

    public DialectConstraint setConstraintType(String constraintType) {
        this.constraintType = constraintType;
        return this;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public DialectConstraint setConstraintName(String constraintName) {
        this.constraintName = constraintName;
        return this;
    }
}

