/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;

public class Column {
    private String columnName;
    private Type columnType;
    private Boolean pkey = false;
    private Boolean notNull = false;
    private Boolean unique = false;
    private String uniqueConstraintName;
    private Boolean index = false;
    private String[] indexNames;
    private Boolean identity = false;
    private String check;
    private String pkeyName;
    private String defaultValue;
    private String sequence;
    private String tableGenerator;
    private String tail;
    private Boolean autoGenerator = false;
    private String comment;
    private Integer[] lengths = new Integer[0];
    private String fkeyReferenceTable;
    private String[] fkeyReferenceColumns;

    public Column(String columnName) {
        if (StrUtils.isEmpty(columnName)) {
            DialectException.throwEX("columnName is not allowed empty");
        }
        this.columnName = columnName;
    }

    public Column notNull() {
        this.notNull = true;
        return this;
    }

    public Column unique() {
        this.unique = true;
        return this;
    }

    public Column unique(String uniqueConstraintName) {
        this.unique = true;
        this.uniqueConstraintName = uniqueConstraintName;
        return this;
    }

    public Column check(String check) {
        this.check = check;
        return this;
    }

    public Column index(String ... indexNames) {
        this.index = true;
        this.indexNames = indexNames;
        return this;
    }

    public Column index() {
        this.index = true;
        return this;
    }

    public Column identity() {
        this.identity = true;
        return this;
    }

    public Column defaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public Column comment(String comment) {
        this.comment = comment;
        return this;
    }

    public Column pkey() {
        this.pkey = true;
        return this;
    }

    public Column pkey(String pkeyName) {
        this.pkey = true;
        this.pkeyName = pkeyName;
        return this;
    }

    public Column fkey(String fkeyReferenceTable, String ... fkeyReferenceColumns) {
        this.fkeyReferenceTable = fkeyReferenceTable;
        this.fkeyReferenceColumns = fkeyReferenceColumns;
        return this;
    }

    public Column sequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public Column tableGenerator(String tableGenerator) {
        this.tableGenerator = tableGenerator;
        return this;
    }

    public Column autoID() {
        this.autoGenerator = true;
        return this;
    }

    public Column tail(String tail) {
        this.tail = tail;
        return this;
    }

    public Column LONG() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public Column BOOLEAN() {
        this.columnType = Type.BOOLEAN;
        return this;
    }

    public Column DOUBLE() {
        this.columnType = Type.DOUBLE;
        return this;
    }

    public Column FLOAT(Integer ... lengths) {
        this.columnType = Type.FLOAT;
        this.lengths = lengths;
        return this;
    }

    public Column INTEGER() {
        this.columnType = Type.INTEGER;
        return this;
    }

    public Column SHORT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public Column BIGDECIMAL(Integer precision, Integer scale) {
        this.columnType = Type.NUMERIC;
        this.lengths = new Integer[]{precision, scale};
        return this;
    }

    public Column STRING(Integer length) {
        this.columnType = Type.VARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public Column DATE() {
        this.columnType = Type.DATE;
        return this;
    }

    public Column TIME() {
        this.columnType = Type.TIME;
        return this;
    }

    public Column TIMESTAMP() {
        this.columnType = Type.TIMESTAMP;
        return this;
    }

    public Column BIGINT() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public Column BINARY(Integer ... lengths) {
        this.columnType = Type.BINARY;
        this.lengths = lengths;
        return this;
    }

    public Column BIT() {
        this.columnType = Type.BIT;
        return this;
    }

    public Column BLOB(Integer ... lengths) {
        this.columnType = Type.BLOB;
        this.lengths = lengths;
        return this;
    }

    public Column CHAR(Integer ... lengths) {
        this.columnType = Type.CHAR;
        this.lengths = lengths;
        return this;
    }

    public Column CLOB(Integer ... lengths) {
        this.columnType = Type.CLOB;
        this.lengths = lengths;
        return this;
    }

    public Column DECIMAL(Integer ... lengths) {
        this.columnType = Type.DECIMAL;
        this.lengths = lengths;
        return this;
    }

    public Column JAVA_OBJECT() {
        this.columnType = Type.JAVA_OBJECT;
        return this;
    }

    public Column LONGNVARCHAR(Integer length) {
        this.columnType = Type.LONGNVARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public Column LONGVARBINARY(Integer ... lengths) {
        this.columnType = Type.LONGVARBINARY;
        this.lengths = lengths;
        return this;
    }

    public Column LONGVARCHAR(Integer ... lengths) {
        this.columnType = Type.LONGVARCHAR;
        this.lengths = lengths;
        return this;
    }

    public Column NCHAR(Integer length) {
        this.columnType = Type.NCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public Column NCLOB() {
        this.columnType = Type.NCLOB;
        return this;
    }

    public Column NUMERIC(Integer ... lengths) {
        this.columnType = Type.NUMERIC;
        this.lengths = lengths;
        return this;
    }

    public Column NVARCHAR(Integer length) {
        this.columnType = Type.NVARCHAR;
        return this;
    }

    public Column OTHER(Integer ... lengths) {
        this.columnType = Type.OTHER;
        this.lengths = lengths;
        return this;
    }

    public Column REAL() {
        this.columnType = Type.REAL;
        return this;
    }

    public Column SMALLINT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public Column TINYINT() {
        this.columnType = Type.TINYINT;
        return this;
    }

    public Column VARBINARY(Integer ... lengths) {
        this.columnType = Type.VARBINARY;
        this.lengths = lengths;
        return this;
    }

    public Column VARCHAR(Integer length) {
        this.columnType = Type.VARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Type getColumnType() {
        return this.columnType;
    }

    public void setColumnType(Type columnType) {
        this.columnType = columnType;
    }

    public Boolean getPkey() {
        return this.pkey;
    }

    public void setPkey(Boolean pkey) {
        this.pkey = pkey;
    }

    public Boolean getNotNull() {
        return this.notNull;
    }

    public void setNotNull(Boolean notNull) {
        this.notNull = notNull;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public String getUniqueConstraintName() {
        return this.uniqueConstraintName;
    }

    public void setUniqueConstraintName(String uniqueConstraintName) {
        this.uniqueConstraintName = uniqueConstraintName;
    }

    public Boolean getIdentity() {
        return this.identity;
    }

    public void setIdentity(Boolean identity) {
        this.identity = identity;
    }

    public String getPkeyName() {
        return this.pkeyName;
    }

    public void setPkeyName(String pkeyName) {
        this.pkeyName = pkeyName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer[] getLengths() {
        return this.lengths;
    }

    public void setLengths(Integer[] lengths) {
        this.lengths = lengths;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getTableGenerator() {
        return this.tableGenerator;
    }

    public void setTableGenerator(String tableGenerator) {
        this.tableGenerator = tableGenerator;
    }

    public Boolean getAutoGenerator() {
        return this.autoGenerator;
    }

    public void setAutoGenerator(Boolean autoGenerator) {
        this.autoGenerator = autoGenerator;
    }

    public String getFkeyReferenceTable() {
        return this.fkeyReferenceTable;
    }

    public void setFkeyReferenceTable(String fkeyReferenceTable) {
        this.fkeyReferenceTable = fkeyReferenceTable;
    }

    public String[] getFkeyReferenceColumns() {
        return this.fkeyReferenceColumns;
    }

    public void setFkeyReferenceColumns(String[] fkeyReferenceColumns) {
        this.fkeyReferenceColumns = fkeyReferenceColumns;
    }

    public Boolean getIndex() {
        return this.index;
    }

    public void setIndex(Boolean index) {
        this.index = index;
    }

    public String getTail() {
        return this.tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public String[] getIndexNames() {
        return this.indexNames;
    }

    public void setIndexName(String[] indexNames) {
        this.indexNames = indexNames;
    }
}

