/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.model.Column;
import com.github.drinkjava2.jdialects.model.FKeyConstraint;
import com.github.drinkjava2.jdialects.model.Sequence;
import com.github.drinkjava2.jdialects.model.TableGenerator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Table {
    private String tableName;
    private String check;
    private String comment;
    private String engineTail;
    private Map<String, Column> columns = new LinkedHashMap<String, Column>();
    private Map<String, Sequence> sequences = new LinkedHashMap<String, Sequence>();
    private Map<String, TableGenerator> tableGenerators = new LinkedHashMap<String, TableGenerator>();
    private List<FKeyConstraint> fkeyConstraints = new ArrayList<FKeyConstraint>();

    public Table() {
    }

    public Table(String tableName) {
        this.tableName = tableName;
    }

    public void addTableGenerator(TableGenerator tableGenerator) {
        DialectException.assureNotNull(tableGenerator, new String[0]);
        DialectException.assureNotEmpty(tableGenerator.getName(), "TableGenerator name can not be empty");
        if (this.tableGenerators.get(tableGenerator.getName().toLowerCase()) != null) {
            DialectException.throwEX("Dulplicated TableGenerator name \"" + tableGenerator.getName() + "\" found in table \"" + this.getTableName() + "\"");
        }
        this.tableGenerators.put(tableGenerator.getName().toLowerCase(), tableGenerator);
    }

    public void addTableGenerator(String name, String tableName, String pkColumnName, String valueColumnName, String pkColumnValue, Integer initialValue, Integer allocationSize) {
        this.addTableGenerator(new TableGenerator(name, tableName, pkColumnName, valueColumnName, pkColumnValue, initialValue, allocationSize));
    }

    public void addSequence(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.addSequence(new Sequence(name, sequenceName, initialValue, allocationSize));
    }

    public void addSequence(Sequence sequence) {
        DialectException.assureNotNull(sequence, new String[0]);
        DialectException.assureNotEmpty(sequence.getSequenceName(), "Sequence name can not be empty");
        this.sequences.put(sequence.getSequenceName().toLowerCase(), sequence);
    }

    public Table check(String check) {
        this.check = check;
        return this;
    }

    public Table comment(String comment) {
        this.comment = comment;
        return this;
    }

    public Table addColumn(Column column) {
        DialectException.assureNotNull(column, new String[0]);
        DialectException.assureNotEmpty(column.getColumnName(), "Column tableName can not be empty");
        if (this.columns.get(column.getColumnName().toLowerCase()) != null) {
            DialectException.throwEX("Dulplicated column name \"" + column.getColumnName() + "\" found in table \"" + this.getTableName() + "\"");
        }
        this.columns.put(column.getColumnName().toLowerCase(), column);
        return this;
    }

    public Column column(String columnName) {
        Column column = new Column(columnName);
        this.addColumn(column);
        return column;
    }

    public Column getColumn(String columnName) {
        DialectException.assureNotEmpty(columnName, new String[0]);
        return this.columns.get(columnName.toUpperCase());
    }

    public FKeyConstraint fkey(String ... columnNames) {
        FKeyConstraint fkey = new FKeyConstraint();
        for (String colName : columnNames) {
            fkey.getColumnNames().add(colName);
        }
        fkey.setTableName(this.tableName);
        this.fkeyConstraints.add(fkey);
        return fkey;
    }

    public Table engineTail(String engineTail) {
        this.engineTail = engineTail;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map<String, Column> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, Column> columns) {
        this.columns = columns;
    }

    public Map<String, Sequence> getSequences() {
        return this.sequences;
    }

    public void setSequences(Map<String, Sequence> sequences) {
        this.sequences = sequences;
    }

    public Map<String, TableGenerator> getTableGenerators() {
        return this.tableGenerators;
    }

    public void setTableGenerators(Map<String, TableGenerator> tableGenerators) {
        this.tableGenerators = tableGenerators;
    }

    public List<FKeyConstraint> getFkeyConstraints() {
        return this.fkeyConstraints;
    }

    public void setFkeyConstraints(List<FKeyConstraint> fkeyConstraints) {
        this.fkeyConstraints = fkeyConstraints;
    }

    public String getEngineTail() {
        return this.engineTail;
    }

    public void setEngineTail(String engineTail) {
        this.engineTail = engineTail;
    }
}

