/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.tinyjdbc;

import com.github.drinkjava2.jdialects.DialectLogger;
import com.github.drinkjava2.jdialects.tinyjdbc.ResultSupport;
import com.github.drinkjava2.jdialects.tinyjdbc.TinyJdbcException;
import com.github.drinkjava2.jdialects.tinyjdbc.TinyResult;
import com.github.drinkjava2.jdialects.tinyjdbc.TinySqlAndParameters;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.SortedMap;
import javax.sql.DataSource;

public class TinyJdbc {
    private static DialectLogger logger = DialectLogger.getLog(TinyJdbc.class);
    public static boolean show_sql = false;
    private static ThreadLocal<ArrayList<Object>> paraCache = new ThreadLocal<ArrayList<Object>>(){

        @Override
        protected ArrayList<Object> initialValue() {
            return new ArrayList<Object>();
        }
    };

    private static void loggerOutputSql(String sql) {
        if (show_sql) {
            logger.info(sql);
        }
    }

    public static String P0(Object ... parameters) {
        paraCache.get().clear();
        return TinyJdbc.P(parameters);
    }

    public static String P(Object ... parameters) {
        for (Object o : parameters) {
            paraCache.get().add(o);
        }
        return "";
    }

    private static void closeResources(ResultSet rs, PreparedStatement pst) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                TinyJdbcException.throwEX(e, e.getMessage());
            }
        }
        try {
            if (pst != null) {
                pst.close();
            }
        }
        catch (SQLException e) {
            TinyJdbcException.throwEX(e, e.getMessage());
        }
    }

    public static Connection getConnection(DataSource datasource) {
        try {
            return datasource.getConnection();
        }
        catch (SQLException e) {
            TinyJdbcException.throwEX(e, "Can not get connection from datasource");
            return null;
        }
    }

    public static void closeConnection(Connection con) {
        try {
            if (con != null && !con.isClosed()) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    TinyJdbcException.throwEX(e, e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            TinyJdbcException.throwEX(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TinySqlAndParameters prepareSQLandParameters(String ... sqls) {
        try {
            StringBuilder sb = new StringBuilder("");
            for (String str : sqls) {
                sb.append(str);
            }
            TinySqlAndParameters sp = new TinySqlAndParameters();
            String sql = sb.toString();
            sp.setSql(sql);
            ArrayList<Object> list = paraCache.get();
            sp.setParameters(list.toArray(new Object[list.size()]));
            TinySqlAndParameters tinySqlAndParameters = sp;
            return tinySqlAndParameters;
        }
        finally {
            paraCache.get().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TinyResult executeQuery(Connection con, String ... sqls) {
        TinyResult tinyResult;
        TinySqlAndParameters pairs = TinyJdbc.prepareSQLandParameters(sqls);
        TinyJdbc.loggerOutputSql(pairs.getSql());
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            TinyResult r;
            int i = 1;
            pst = con.prepareStatement(pairs.getSql());
            for (Object obj : pairs.getParameters()) {
                pst.setObject(i++, obj);
            }
            rs = pst.executeQuery();
            tinyResult = r = ResultSupport.toResult(rs);
        }
        catch (SQLException e) {
            try {
                TinyJdbcException.throwEX(e, e.getMessage());
            }
            catch (Throwable throwable) {
                TinyJdbc.closeResources(rs, pst);
                throw throwable;
            }
            TinyJdbc.closeResources(rs, pst);
            return null;
        }
        TinyJdbc.closeResources(rs, pst);
        return tinyResult;
    }

    public static Integer queryForInteger(Connection con, String ... sqls) {
        TinyResult rst = TinyJdbc.executeQuery(con, sqls);
        if (rst != null && rst.getRowCount() == 1) {
            SortedMap row = rst.getRows()[0];
            Object s = row.get(row.keySet().iterator().next());
            if (s == null) {
                return 0;
            }
            return Integer.parseInt("" + s);
        }
        TinyJdbcException.throwEX("TinyJdbc queryForObject error: null or multiple lines found for sql:" + sqls);
        return null;
    }

    public static Object queryForObject(Connection con, String ... sqls) {
        TinyResult rst = TinyJdbc.executeQuery(con, sqls);
        if (rst != null && rst.getRowCount() == 1) {
            SortedMap row = rst.getRows()[0];
            return row.get(row.keySet().iterator().next());
        }
        TinyJdbcException.throwEX("TinyJdbc queryForObject error: null or multiple lines found for sql:" + sqls);
        return null;
    }

    public static String queryForString(Connection con, String ... sqls) {
        return (String)TinyJdbc.queryForObject(con, sqls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int executeUpdate(Connection con, String ... sqls) {
        int n;
        TinySqlAndParameters pairs = TinyJdbc.prepareSQLandParameters(sqls);
        TinyJdbc.loggerOutputSql(pairs.getSql());
        PreparedStatement pst = null;
        try {
            int count;
            int i = 1;
            pst = con.prepareStatement(pairs.getSql());
            for (Object obj : pairs.getParameters()) {
                pst.setObject(i++, obj);
            }
            n = count = pst.executeUpdate();
        }
        catch (SQLException e) {
            try {
                TinyJdbcException.throwEX(e, e.getMessage());
            }
            catch (Throwable throwable) {
                TinyJdbc.closeResources(null, pst);
                throw throwable;
            }
            TinyJdbc.closeResources(null, pst);
            return 0;
        }
        TinyJdbc.closeResources(null, pst);
        return n;
    }

    public static boolean executeQuiet(Connection con, String ... sqls) {
        try {
            return TinyJdbc.execute(con, sqls);
        }
        catch (Exception e) {
            TinyJdbcException.eatException(e);
            return false;
        }
    }

    public static void executeManySqls(Connection con, String ... sqls) {
        for (String str : sqls) {
            TinyJdbc.execute(con, str);
        }
    }

    public static void executeQuietManySqls(Connection con, String ... sqls) {
        for (String str : sqls) {
            TinyJdbc.executeQuiet(con, str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(Connection con, String ... sqls) {
        TinySqlAndParameters pairs = TinyJdbc.prepareSQLandParameters(sqls);
        TinyJdbc.loggerOutputSql(pairs.getSql());
        PreparedStatement pst = null;
        try {
            boolean bl;
            pst = con.prepareStatement(pairs.getSql());
            int i = 1;
            for (Object obj : pairs.getParameters()) {
                pst.setObject(i++, obj);
            }
            boolean bl2 = bl = pst.execute();
            return bl2;
        }
        catch (SQLException e) {
            TinyJdbcException.throwEX(e, e.getMessage());
        }
        finally {
            TinyJdbc.closeResources(null, pst);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTableCount(Connection con) {
        PreparedStatement pst = null;
        try {
            DatabaseMetaData metaData = con.getMetaData();
            int tableCount = 0;
            ResultSet rs = metaData.getTables(con.getCatalog(), "test", null, new String[]{"TABLE"});
            while (rs.next()) {
                ++tableCount;
                System.out.println(rs.getString("TABLE_NAME"));
            }
            int n = tableCount;
            return n;
        }
        catch (SQLException e) {
            TinyJdbcException.throwEX(e, e.getMessage());
        }
        finally {
            TinyJdbc.closeResources(null, pst);
        }
        return 0;
    }
}

