/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DebugUtils;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.UUIDAnyGenerator;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.util.Iterator;
import java.util.List;

public class ColumnModel {
    private String columnName;
    private TableModel tableModel;
    private Type columnType;
    private Boolean pkey = false;
    private Boolean nullable = true;
    private String check;
    private String defaultValue;
    private String tail;
    private String comment;
    private Integer[] lengths = new Integer[0];
    private GenerationType idGenerationType;
    private String idGeneratorName;
    private String entityField;
    private Integer length = 255;
    private Integer precision = 0;
    private Integer scale = 0;
    private Boolean insertable = true;
    private Boolean updatable = true;
    private Boolean transientable = false;
    private String[] shardTable = null;
    private String[] shardDatabase = null;

    public ColumnModel(String columnName) {
        if (StrUtils.isEmpty(columnName)) {
            DialectException.throwEX("columnName is not allowed empty");
        }
        this.columnName = columnName;
    }

    public ColumnModel notNull() {
        this.nullable = false;
        return this;
    }

    public ColumnModel check(String check) {
        this.check = check;
        return this;
    }

    public ColumnModel newCopy() {
        ColumnModel col = new ColumnModel(this.columnName);
        col.columnType = this.columnType;
        col.pkey = (boolean)this.pkey;
        col.nullable = this.nullable;
        col.check = this.check;
        col.defaultValue = this.defaultValue;
        col.tail = this.tail;
        col.comment = this.comment;
        col.lengths = this.lengths;
        col.entityField = this.entityField;
        col.length = this.length;
        col.precision = this.precision;
        col.scale = this.scale;
        col.insertable = this.insertable;
        col.updatable = this.updatable;
        col.transientable = this.transientable;
        col.idGeneratorName = this.idGeneratorName;
        col.idGenerationType = this.idGenerationType;
        col.shardTable = this.shardTable;
        col.shardDatabase = this.shardDatabase;
        return col;
    }

    public ColumnModel singleIndex(String indexName) {
        this.makeSureTableModelExist();
        DialectException.assureNotEmpty(indexName, "indexName can not be empty");
        this.tableModel.index(indexName).columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleIndex() {
        this.makeSureTableModelExist();
        this.tableModel.index().columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleUnique(String uniqueName) {
        this.makeSureTableModelExist();
        DialectException.assureNotEmpty(uniqueName, "indexName can not be empty");
        this.tableModel.unique(uniqueName).columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleUnique() {
        this.makeSureTableModelExist();
        this.tableModel.unique().columns(this.getColumnName());
        return this;
    }

    private void makeSureTableModelExist() {
        DialectException.assureNotNull(this.tableModel, "ColumnModel should belong to a TableModel, please call tableModel.column() method first.");
    }

    public ColumnModel defaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public ColumnModel comment(String comment) {
        this.comment = comment;
        return this;
    }

    public ColumnModel pkey() {
        this.pkey = true;
        return this;
    }

    public ColumnModel shardTable(String ... shardTable) {
        this.shardTable = shardTable;
        return this;
    }

    public ColumnModel shardDatabase(String ... shardDatabase) {
        this.shardDatabase = shardDatabase;
        return this;
    }

    public ColumnModel id() {
        this.pkey = true;
        return this;
    }

    public FKeyModel singleFKey(String ... refTableAndColumns) {
        this.makeSureTableModelExist();
        if (refTableAndColumns == null || refTableAndColumns.length > 2) {
            throw new DialectException("singleFKey() first parameter should be table name, second parameter(optional) should be column name");
        }
        return this.tableModel.fkey().columns(this.columnName).refs(refTableAndColumns);
    }

    public IdGenerator getIdGenerator() {
        this.makeSureTableModelExist();
        return this.tableModel.getIdGenerator(this.idGenerationType, this.idGeneratorName);
    }

    public ColumnModel identityId() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.IDENTITY;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuid25() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID25;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuid32() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID32;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuid36() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID36;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel snowflake() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.SNOWFLAKE;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuidAny(String name, Integer length) {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID_ANY;
        this.idGeneratorName = name;
        if (this.tableModel.getIdGenerator(GenerationType.UUID_ANY, this.idGeneratorName) == null) {
            this.tableModel.getIdGenerators().add(new UUIDAnyGenerator(name, length));
        }
        return this;
    }

    public ColumnModel timeStampId() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.TIMESTAMP;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel autoId() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.AUTO;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel sortedUUID(String name, Integer sortedLength, Integer uuidLength) {
        this.makeSureTableModelExist();
        this.tableModel.sortedUUIDGenerator(name, sortedLength, uuidLength);
        this.idGenerationType = GenerationType.SORTED_UUID;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel sequenceGenerator(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.makeSureTableModelExist();
        this.tableModel.sequenceGenerator(name, sequenceName, initialValue, allocationSize);
        this.idGenerationType = GenerationType.SEQUENCE;
        this.idGeneratorName = name;
        return this;
    }

    public ColumnModel idGenerator(String idGeneratorName) {
        this.makeSureTableModelExist();
        this.idGenerationType = null;
        this.idGeneratorName = idGeneratorName;
        return this;
    }

    public ColumnModel tableGenerator(String name, String tableName, String pkColumnName, String valueColumnName, String pkColumnValue, Integer initialValue, Integer allocationSize) {
        this.makeSureTableModelExist();
        this.tableModel.tableGenerator(name, tableName, pkColumnName, valueColumnName, pkColumnValue, initialValue, allocationSize);
        this.idGenerationType = GenerationType.TABLE;
        this.idGeneratorName = name;
        return this;
    }

    public ColumnModel tail(String tail) {
        this.tail = tail;
        return this;
    }

    public ColumnModel entityField(String entityFieldName) {
        DialectException.assureNotEmpty(entityFieldName, "entityFieldName can not be empty");
        this.entityField = entityFieldName;
        if (this.tableModel != null) {
            List<ColumnModel> oldColumns = this.tableModel.getColumns();
            Iterator<ColumnModel> columnIter = oldColumns.iterator();
            while (columnIter.hasNext()) {
                ColumnModel column = columnIter.next();
                if (!entityFieldName.equals(column.getEntityField()) || this.getColumnName().equals(column.getColumnName())) continue;
                columnIter.remove();
            }
        }
        return this;
    }

    public ColumnModel insertable(Boolean insertable) {
        this.insertable = insertable;
        return this;
    }

    public ColumnModel updatable(Boolean updatable) {
        this.updatable = updatable;
        return this;
    }

    public String getDebugInfo() {
        return DebugUtils.getColumnModelDebugInfo(this);
    }

    public void checkReadOnly() {
        if (this.tableModel != null && this.tableModel.getReadOnly().booleanValue()) {
            throw new DialectException("TableModel '" + this.tableModel.getTableName() + "' is readOnly, can not be modified.");
        }
    }

    public ColumnModel LONG() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public ColumnModel BOOLEAN() {
        this.columnType = Type.BOOLEAN;
        return this;
    }

    public ColumnModel DOUBLE() {
        this.columnType = Type.DOUBLE;
        return this;
    }

    public ColumnModel FLOAT(Integer ... lengths) {
        this.columnType = Type.FLOAT;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel INTEGER() {
        this.columnType = Type.INTEGER;
        return this;
    }

    public ColumnModel SHORT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public ColumnModel BIGDECIMAL(Integer precision, Integer scale) {
        this.columnType = Type.NUMERIC;
        this.lengths = new Integer[]{precision, scale};
        return this;
    }

    public ColumnModel STRING(Integer length) {
        this.columnType = Type.VARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel DATE() {
        this.columnType = Type.DATE;
        return this;
    }

    public ColumnModel TIME() {
        this.columnType = Type.TIME;
        return this;
    }

    public ColumnModel TIMESTAMP() {
        this.columnType = Type.TIMESTAMP;
        return this;
    }

    public ColumnModel BIGINT() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public ColumnModel BINARY(Integer ... lengths) {
        this.columnType = Type.BINARY;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel BIT() {
        this.columnType = Type.BIT;
        return this;
    }

    public ColumnModel BLOB(Integer ... lengths) {
        this.columnType = Type.BLOB;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel CHAR(Integer ... lengths) {
        this.columnType = Type.CHAR;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel CLOB(Integer ... lengths) {
        this.columnType = Type.CLOB;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel DECIMAL(Integer ... lengths) {
        this.columnType = Type.DECIMAL;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel JAVA_OBJECT() {
        this.columnType = Type.JAVA_OBJECT;
        return this;
    }

    public ColumnModel LONGNVARCHAR(Integer length) {
        this.columnType = Type.LONGNVARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel LONGVARBINARY(Integer ... lengths) {
        this.columnType = Type.LONGVARBINARY;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel LONGVARCHAR(Integer ... lengths) {
        this.columnType = Type.LONGVARCHAR;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel NCHAR(Integer length) {
        this.columnType = Type.NCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel NCLOB() {
        this.columnType = Type.NCLOB;
        return this;
    }

    public ColumnModel NUMERIC(Integer ... lengths) {
        this.columnType = Type.NUMERIC;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel NVARCHAR(Integer length) {
        this.columnType = Type.NVARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel OTHER(Integer ... lengths) {
        this.columnType = Type.OTHER;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel REAL() {
        this.columnType = Type.REAL;
        return this;
    }

    public ColumnModel SMALLINT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public ColumnModel TINYINT() {
        this.columnType = Type.TINYINT;
        return this;
    }

    public ColumnModel VARBINARY(Integer ... lengths) {
        this.columnType = Type.VARBINARY;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel VARCHAR(Integer length) {
        this.columnType = Type.VARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public Type getColumnType() {
        return this.columnType;
    }

    public void setColumnType(Type columnType) {
        this.columnType = columnType;
    }

    public Boolean getPkey() {
        return this.pkey;
    }

    public void setPkey(Boolean pkey) {
        this.pkey = pkey;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public GenerationType getIdGenerationType() {
        return this.idGenerationType;
    }

    public void setIdGenerationType(GenerationType idGenerationType) {
        this.idGenerationType = idGenerationType;
    }

    public String getIdGeneratorName() {
        return this.idGeneratorName;
    }

    public void setIdGeneratorName(String idGeneratorName) {
        this.idGeneratorName = idGeneratorName;
    }

    public String getTail() {
        return this.tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer[] getLengths() {
        return this.lengths;
    }

    public void setLengths(Integer[] lengths) {
        this.lengths = lengths;
    }

    public String getEntityField() {
        return this.entityField;
    }

    public void setEntityField(String entityField) {
        this.entityField = entityField;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Boolean getInsertable() {
        return this.insertable;
    }

    public void setInsertable(Boolean insertable) {
        this.insertable = insertable;
    }

    public Boolean getUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(Boolean updatable) {
        this.updatable = updatable;
    }

    public Boolean getTransientable() {
        return this.transientable;
    }

    public void setTransientable(Boolean transientable) {
        this.transientable = transientable;
    }

    public String[] getShardTable() {
        return this.shardTable;
    }

    public void setShardTable(String[] shardTable) {
        this.shardTable = shardTable;
    }

    public String[] getShardDatabase() {
        return this.shardDatabase;
    }

    public void setShardDatabase(String[] shardDatabase) {
        this.shardDatabase = shardDatabase;
    }
}

