/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.JDBPRO;
import com.github.drinkjava2.jdbpro.LinkStyleArrayList;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.IdentityIdGenerator;
import com.github.drinkjava2.jdialects.id.SnowflakeCreator;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.JSQLBOX;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.entitynet.EntityIdUtils;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import com.github.drinkjava2.jsqlbox.handler.EntityNetHandler;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import com.github.drinkjava2.jsqlbox.sqlitem.EntityKeyItem;
import com.github.drinkjava2.jsqlbox.sqlitem.SampleItem;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SqlBoxContextUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel[] loadMetaTableModels(SqlBoxContext ctx, Dialect dialect) {
        Connection con = null;
        SQLException sqlException = null;
        try {
            con = ctx.prepareConnection();
            TableModel[] tableModelArray = TableModelUtils.db2Models(con, dialect);
            return tableModelArray;
        }
        catch (SQLException e) {
            sqlException = e;
        }
        finally {
            try {
                ctx.close(con);
            }
            catch (SQLException e) {
                if (sqlException != null) {
                    sqlException.setNextException(e);
                }
                sqlException = e;
            }
        }
        throw new SqlBoxException(sqlException);
    }

    public static ColumnModel findMatchColumnForJavaField(String entityField, TableModel tableModel) {
        SqlBoxException.assureNotNull(tableModel, "Can not find column for '" + entityField + "' in null table ");
        ColumnModel col = tableModel.getColumnByFieldName(entityField);
        SqlBoxException.assureNotNull(col, "Can not find column for '" + entityField + "' in table '" + tableModel.getTableName() + "'");
        return col;
    }

    public static String getShardedTB(SqlBoxContext ctx, Object entityOrClass, Object ... shardKey) {
        if (ctx.getShardingTools() == null || ctx.getShardingTools().length == 0) {
            throw new SqlBoxException("No shardingTools be set.");
        }
        TableModel model = SqlBoxContextUtils.findEntityOrClassTableModel(entityOrClass);
        String table = null;
        for (ShardingTool sh : ctx.getShardingTools()) {
            String[] result = sh.handleShardTable(ctx, model, shardKey);
            if (result == null) continue;
            if (result.length == 0) {
                throw new SqlBoxException("Can not find sharding table for target '" + model.getEntityClass() + "'");
            }
            if (result.length > 1) {
                throw new SqlBoxException("Found more than 1 sharding tables for target '" + model.getEntityClass() + "', jSqlBox current version do not support auto-join, to solve this issue you need adjust your ShardTable search condition");
            }
            table = result[0];
            break;
        }
        return table;
    }

    public static SqlBoxContext getShardedDB(SqlBoxContext currentCtx, Object entityOrClass, Object ... shardKey) {
        if (currentCtx.getMasters() == null || currentCtx.getMasters().length == 0) {
            throw new SqlBoxException("Current SqlBoxContext did not set masters property but try do shardDatabase opertation.");
        }
        if (currentCtx.getShardingTools() == null || currentCtx.getShardingTools().length == 0) {
            throw new SqlBoxException("No shardingTools be set.");
        }
        TableModel model = SqlBoxContextUtils.findEntityOrClassTableModel(entityOrClass);
        SqlBoxContext masterCtx = null;
        for (ShardingTool sh : currentCtx.getShardingTools()) {
            SqlBoxContext[] result = sh.handleShardDatabase(currentCtx, model, shardKey);
            if (result == null) continue;
            if (result.length == 0) {
                throw new SqlBoxException("Can not find master SqlBoxContext for '" + model.getEntityClass() + "'");
            }
            if (result.length > 1) {
                throw new SqlBoxException("Found more than 1 SqlBoxContext tables for target '" + model.getEntityClass() + "', jSqlBox current version do not support auto-join, to solve this issue you need adjust your ShardDatabase search condition.");
            }
            masterCtx = result[0];
            break;
        }
        return masterCtx;
    }

    public static TableModel findTableModel(Object entityOrClass, Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findFirstModel(optionItems);
        if (model != null) {
            return model;
        }
        return SqlBoxContextUtils.findEntityOrClassTableModel(entityOrClass);
    }

    public static TableModel findEntityOrClassTableModel(Object entityOrClass) {
        if (entityOrClass == null) {
            throw new SqlBoxException("Can not build TableModel from null entityOrClass");
        }
        if (entityOrClass instanceof TableModel) {
            return (TableModel)entityOrClass;
        }
        if (entityOrClass instanceof Class) {
            return TableModelUtils.entity2ReadOnlyModel((Class)entityOrClass);
        }
        return TableModelUtils.entity2ReadOnlyModel(entityOrClass.getClass());
    }

    public static TableModel findFirstModel(Object ... optionItems) {
        for (Object item : optionItems) {
            if (item instanceof TableModel) {
                return (TableModel)item;
            }
            if (!(item instanceof Class)) continue;
            return TableModelUtils.entity2ReadOnlyModel((Class)item);
        }
        return null;
    }

    public static TableModel[] findAllModels(Object ... sqlItems) {
        ArrayList<TableModel> result = new ArrayList<TableModel>();
        SqlBoxContextUtils.doFindAllModels(result, sqlItems);
        return result.toArray(new TableModel[result.size()]);
    }

    private static void doFindAllModels(List<TableModel> result, Object ... sqlItems) {
        for (Object item : sqlItems) {
            if (item instanceof TableModel) {
                result.add((TableModel)item);
                continue;
            }
            if (item instanceof Class) {
                result.add(TableModelUtils.entity2ReadOnlyModel((Class)item));
                continue;
            }
            if (!item.getClass().isArray()) continue;
            SqlBoxContextUtils.doFindAllModels(result, (Object[])item);
        }
    }

    public static Object[] findModelAlias(Object ... sqlItems) {
        ArrayList<Object> result = new ArrayList<Object>();
        SqlBoxContextUtils.dofindModelAlias(result, sqlItems);
        return result.toArray(new Object[result.size()]);
    }

    private static void dofindModelAlias(List<Object> result, Object ... sqlItems) {
        for (Object item : sqlItems) {
            SqlItem sqItem;
            SqlOption sqlItemType;
            if (item instanceof TableModel) {
                result.add((TableModel)item);
                continue;
            }
            if (item instanceof Class) {
                result.add(TableModelUtils.entity2ReadOnlyModel((Class)item));
                continue;
            }
            if (item.getClass().isArray()) {
                SqlBoxContextUtils.dofindModelAlias(result, (Object[])item);
                continue;
            }
            if (!(item instanceof SqlItem) || !SqlOption.ALIAS.equals((Object)(sqlItemType = (sqItem = (SqlItem)item).getType()))) continue;
            result.add(item);
        }
    }

    public static Object[] findNotModelAlias(Object ... sqlItems) {
        ArrayList<Object> result = new ArrayList<Object>();
        SqlBoxContextUtils.dofindNotModelAlias(result, sqlItems);
        return result.toArray(new Object[result.size()]);
    }

    private static void dofindNotModelAlias(List<Object> result, Object ... sqlItems) {
        for (Object item : sqlItems) {
            if (item instanceof TableModel || item instanceof Class) continue;
            if (item.getClass().isArray()) {
                SqlBoxContextUtils.dofindNotModelAlias(result, (Object[])item);
                continue;
            }
            if (item instanceof SqlItem) {
                if (SqlOption.ALIAS.equals((Object)((SqlItem)item).getType())) continue;
                result.add(item);
                continue;
            }
            result.add(item);
        }
    }

    public static void createLastAutoAliasName(PreparedSQL ps) {
        char[] chars;
        if (ps.getModels() == null || ps.getModels().length == 0) {
            throw new SqlBoxException("No tableModel found");
        }
        TableModel model = (TableModel)ps.getModels()[ps.getModels().length - 1];
        String[] aliases = ps.getAliases();
        StringBuilder sb = new StringBuilder();
        for (char c : chars = model.getEntityClass().getSimpleName().toCharArray()) {
            if (c < 'A' || c > 'Z') continue;
            sb.append(c);
        }
        String alias = sb.toString().toLowerCase();
        int count = 1;
        String newAlias = alias;
        boolean found = false;
        block1: do {
            for (int i = 0; i < aliases.length - 2; ++i) {
                if (!newAlias.equals(aliases[i])) continue;
                newAlias = alias + count++;
                found = true;
                continue block1;
            }
        } while (found);
        ps.setLastAliases(newAlias);
    }

    public static <T> T mapToEntityBean(TableModel model, Map<String, Object> oneRow) {
        if (oneRow == null || oneRow.isEmpty()) {
            throw new SqlBoxException("Can not use null or empty row to convert to EntityBean");
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), "Can not find entityClass setting in model.");
        Object bean = ClassCacheUtils.createNewEntity(model.getEntityClass());
        for (ColumnModel col : model.getColumns()) {
            boolean foundValue = false;
            for (Map.Entry<String, Object> row : oneRow.entrySet()) {
                if (!row.getKey().equalsIgnoreCase(col.getColumnName())) continue;
                foundValue = true;
                SqlBoxException.assureNotEmpty(col.getEntityField(), "EntityField not found for column '" + col.getColumnName() + "'");
                ClassCacheUtils.writeValueToBeanField(bean, col.getEntityField(), row.getValue());
            }
            if (!col.getPkey().booleanValue() || foundValue) continue;
            throw new SqlBoxException("One prime-key not set value: '" + col.getColumnName() + "'");
        }
        return (T)bean;
    }

    public static <T> T entityOrClassToBean(Object entityOrClass) {
        if (entityOrClass == null) {
            throw new SqlBoxException("Can build Bean for null entityOrClass");
        }
        if (entityOrClass instanceof Class) {
            try {
                return ((Class)entityOrClass).newInstance();
            }
            catch (Exception e) {
                throw new SqlBoxException("Can not create new instance for '" + entityOrClass + "'");
            }
        }
        return (T)entityOrClass;
    }

    public static void notAllowSharding(ColumnModel col) {
        if (col.getShardTable() != null || col.getShardDatabase() != null) {
            throw new SqlBoxException("Fail to execute entity CRUD operation because found sharding column is not included in prime Key columns");
        }
    }

    public static void appendLeftJoinSQL(PreparedSQL ps) {
        int i;
        Object[] m = ps.getModels();
        String[] a = ps.getAliases();
        SqlBoxException.assureTrue(m != null && m != null & m.length == a.length, new String[0]);
        StringBuilder sb = new StringBuilder(" select ");
        boolean ifFirst = true;
        for (i = 0; i < m.length; ++i) {
            TableModel md = (TableModel)m[i];
            for (ColumnModel col : md.getColumns()) {
                if (col.getTransientable().booleanValue()) continue;
                if (ifFirst) {
                    ifFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(a[i]).append(".").append(col.getColumnName()).append(" as ").append(a[i]).append("_").append(col.getColumnName());
            }
        }
        sb.append(" from ");
        sb.append(((TableModel)m[0]).getTableName()).append(" ").append(a[0]).append(" ");
        for (i = 1; i < m.length; ++i) {
            sb.append(" left join ");
            sb.append(((TableModel)m[i]).getTableName()).append(" ").append(a[i]);
            sb.append(" on ");
            SqlBoxContextUtils.appendKeyEquelsSqlPiece(sb, a[i - 1], (TableModel)m[i - 1], a[i], (TableModel)m[i]);
        }
        ps.addSql(sb.toString());
    }

    private static void appendKeyEquelsSqlPiece(StringBuilder sb, String a1, TableModel m1, String a2, TableModel m2) {
        String refTable;
        List<FKeyModel> fkeys = m1.getFkeyConstraints();
        for (FKeyModel fkey : fkeys) {
            refTable = fkey.getRefTableAndColumns()[0];
            if (!refTable.equalsIgnoreCase(m2.getTableName())) continue;
            SqlBoxContextUtils.realDoAppendKeyEquelsSqlPiece(sb, a1, m1, a2, m2, fkey);
            return;
        }
        fkeys = m2.getFkeyConstraints();
        for (FKeyModel fkey : fkeys) {
            refTable = fkey.getRefTableAndColumns()[0];
            if (!refTable.equalsIgnoreCase(m1.getTableName())) continue;
            SqlBoxContextUtils.realDoAppendKeyEquelsSqlPiece(sb, a2, m2, a1, m1, fkey);
            return;
        }
        throw new SqlBoxException("Not found relationship(foreign key) setting between '" + m1.getEntityClass() + "' and '" + m2.getEntityClass() + "'");
    }

    private static void realDoAppendKeyEquelsSqlPiece(StringBuilder sb, String a, TableModel ma, String b, TableModel mb, FKeyModel fkey) {
        int i = 0;
        for (String col : fkey.getColumnNames()) {
            if (i > 0) {
                sb.append("and ");
            }
            sb.append(a).append(".").append(col).append("=").append(b).append(".").append(fkey.getRefTableAndColumns()[i + 1]).append(" ");
            ++i;
        }
    }

    private static void crudMethods___________________________________() {
    }

    public static int entityInsertTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        String identityFieldName = null;
        Type identityType = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityBean.getClass());
        Boolean ignoreNull = null;
        jSQL.append(" (");
        boolean foundColumnToInsert = false;
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue() || !col.getInsertable().booleanValue()) continue;
            if (col.getIdGenerationType() != null || !StrUtils.isEmpty(col.getIdGeneratorName())) {
                if (col.getIdGenerator() == null) {
                    throw new SqlBoxException("No IdGenerator found for column '" + col.getColumnName() + "'");
                }
                IdGenerator idGen = col.getIdGenerator();
                if (GenerationType.IDENTITY.equals((Object)idGen.getGenerationType())) {
                    if (identityFieldName != null) {
                        throw new SqlBoxException("More than 1 identity field found for table '" + model.getTableName() + "'");
                    }
                    identityType = col.getColumnType();
                    identityFieldName = fieldName;
                } else if (GenerationType.SNOWFLAKE.equals((Object)idGen.getGenerationType())) {
                    jSQL.append(col.getColumnName());
                    SnowflakeCreator snow = ctx.getSnowflakeCreator();
                    if (snow == null) {
                        throw new SqlBoxException("Current SqlBoxContext no SnowflakeCreator found when try to create a Snowflake value");
                    }
                    Long id = snow.nextId();
                    jSQL.append(JDBPRO.param(id));
                    jSQL.append(", ");
                    foundColumnToInsert = true;
                    ClassCacheUtils.writeValueToBeanField(entityBean, fieldName, id);
                } else {
                    jSQL.append(col.getColumnName());
                    Object id = idGen.getNextID(ctx, ctx.getDialect(), col.getColumnType());
                    jSQL.append(JDBPRO.param(id));
                    jSQL.append(", ");
                    foundColumnToInsert = true;
                    ClassCacheUtils.writeValueToBeanField(entityBean, fieldName, id);
                }
            } else {
                Object value = ClassCacheUtils.readValueFromBeanField(entityBean, fieldName);
                if (value == null && ignoreNull == null) {
                    for (Object itemObject : optionItems) {
                        if (!SqlOption.IGNORE_NULL.equals(itemObject)) continue;
                        ignoreNull = true;
                        break;
                    }
                    if (ignoreNull == null) {
                        ignoreNull = false;
                    }
                }
                if (ignoreNull == null || !ignoreNull.booleanValue() || value != null) {
                    jSQL.append(col.getColumnName());
                    jSQL.append(new SqlItem(SqlOption.PARAM, value));
                    jSQL.append(", ");
                    foundColumnToInsert = true;
                }
            }
            if (col.getPkey().booleanValue()) {
                if (col.getShardTable() != null) {
                    shardTableItem = JSQLBOX.shardTB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                }
                if (col.getShardDatabase() == null) continue;
                shardDbItem = JSQLBOX.shardDB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                continue;
            }
            SqlBoxContextUtils.notAllowSharding(col);
        }
        if (foundColumnToInsert) {
            jSQL.remove(jSQL.size() - 1);
        }
        if (shardTableItem != null) {
            jSQL.frontAdd(shardTableItem);
        } else {
            jSQL.frontAdd(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.frontAdd("insert into ");
        jSQL.append(") ");
        jSQL.append(JDBPRO.valuesQuestions());
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        int result = ctx.iUpdate(jSQL.toArray());
        if (ctx.isBatchEnabled()) {
            return 1;
        }
        if (identityFieldName != null) {
            Object identityId = IdentityIdGenerator.INSTANCE.getNextID(ctx, ctx.getDialect(), identityType);
            ClassCacheUtils.writeValueToBeanField(entityBean, identityFieldName, identityId);
        }
        return result;
    }

    public static int entityUpdateTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Boolean ignoreNull = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityBean.getClass());
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue() || !col.getUpdatable().booleanValue()) continue;
            Object value = ClassCacheUtils.readValueFromBeanField(entityBean, fieldName);
            if (col.getPkey().booleanValue()) {
                if (!where.isEmpty()) {
                    where.append(" and ");
                }
                where.append(col.getColumnName()).append("=?");
                where.append(JDBPRO.param(value));
                if (col.getShardTable() != null) {
                    shardTableItem = JSQLBOX.shardTB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                }
                if (col.getShardDatabase() == null) continue;
                shardDbItem = JSQLBOX.shardDB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                continue;
            }
            SqlBoxContextUtils.notAllowSharding(col);
            if (value == null && ignoreNull == null) {
                for (Object itemObject : optionItems) {
                    if (!SqlOption.IGNORE_NULL.equals(itemObject)) continue;
                    ignoreNull = true;
                    break;
                }
                if (ignoreNull == null) {
                    ignoreNull = false;
                }
            }
            if (ignoreNull != null && ignoreNull.booleanValue() && value == null) continue;
            if (!jSQL.isEmpty()) {
                jSQL.append(", ");
            }
            jSQL.append(col.getColumnName()).append("=? ");
            jSQL.append(JDBPRO.param(value));
        }
        jSQL.frontAdd(" set ");
        if (shardTableItem != null) {
            jSQL.frontAdd(shardTableItem);
        } else {
            jSQL.frontAdd(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.frontAdd("update ");
        jSQL.append(" where ");
        jSQL.addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        int rowAffected = ctx.iUpdate(jSQL.toObjectArray());
        if (ctx.isBatchEnabled()) {
            return 1;
        }
        return rowAffected;
    }

    public static int entityDeleteTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityBean.getClass());
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue() || !col.getPkey().booleanValue()) continue;
            Object value = ClassCacheUtils.readValueFromBeanField(entityBean, fieldName);
            if (!where.isEmpty()) {
                where.append(" and ");
            }
            where.append(JDBPRO.param(value));
            where.append(col.getColumnName()).append("=? ");
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
        }
        if (where.isEmpty()) {
            throw new SqlBoxException("No primary key found for entityBean");
        }
        jSQL.append("delete from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        jSQL.append(SingleTonHandlers.arrayHandler);
        int rowAffected = ctx.iUpdate(jSQL.toObjectArray());
        if (ctx.isBatchEnabled()) {
            return 1;
        }
        return rowAffected;
    }

    public static int entityDeleteByIdTry(SqlBoxContext ctx, Class<?> entityClass, Object id, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityClass);
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                Object value = EntityIdUtils.readFeidlValueFromEntityId(id, model, fieldName);
                if (!where.isEmpty()) {
                    where.append(" and ");
                }
                where.append(JDBPRO.param(value));
                where.append(col.getColumnName()).append("=? ");
                if (col.getShardTable() != null) {
                    shardTableItem = JSQLBOX.shardTB(EntityIdUtils.readFeidlValueFromEntityId(id, model, fieldName));
                }
                if (col.getShardDatabase() == null) continue;
                shardDbItem = JSQLBOX.shardDB(EntityIdUtils.readFeidlValueFromEntityId(id, model, fieldName));
                continue;
            }
            SqlBoxContextUtils.notAllowSharding(col);
        }
        if (where.isEmpty()) {
            throw new SqlBoxException("No primary key found for entityBean");
        }
        jSQL.append("delete from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        jSQL.append(SingleTonHandlers.arrayHandler);
        int rowAffected = ctx.iUpdate(jSQL.toObjectArray());
        if (ctx.isBatchEnabled()) {
            return 1;
        }
        return rowAffected;
    }

    public static int entityLoadTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<String> where = new LinkStyleArrayList<String>();
        ArrayList<String> allFieldNames = new ArrayList<String>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> writeMethods = ClassCacheUtils.getClassWriteMethods(entityBean.getClass());
        for (String fieldName : writeMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                where.append(col.getColumnName()).append("=?").append((String)((Object)JDBPRO.param(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName)))).append(" and ");
                if (col.getShardTable() != null) {
                    shardTableItem = JSQLBOX.shardTB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                }
                if (col.getShardDatabase() != null) {
                    shardDbItem = JSQLBOX.shardDB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                }
            } else {
                SqlBoxContextUtils.notAllowSharding(col);
            }
            jSQL.append(col.getColumnName()).append(", ");
            allFieldNames.add(col.getEntityField());
        }
        jSQL.remove(jSQL.size() - 1);
        if (where.isEmpty()) {
            throw new SqlBoxException("No PKey column found from tableModel '" + model.getTableName() + "'");
        }
        where.remove(where.size() - 1);
        jSQL.frontAdd("select ").append(" from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        jSQL.append(SingleTonHandlers.arrayListHandler);
        List valuesList = (List)ctx.iQuery(jSQL.toObjectArray());
        if (valuesList == null || valuesList.isEmpty()) {
            return 0;
        }
        Object[] values = (Object[])valuesList.get(0);
        try {
            for (int i = 0; i < values.length; ++i) {
                Method writeMethod = writeMethods.get(allFieldNames.get(i));
                SqlBoxException.assureNotNull(writeMethod, "Not found write method of field '" + (String)allFieldNames.get(i) + "' in " + entityBean.getClass());
                writeMethod.invoke(entityBean, values[i]);
            }
        }
        catch (Exception e) {
            throw new SqlBoxException(e);
        }
        return valuesList.size();
    }

    public static <T> T entityLoadByIdTry(SqlBoxContext ctx, Class<T> entityClass, Object idOrIdMap, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        T bean = SqlBoxContextUtils.entityOrClassToBean(entityClass);
        bean = EntityIdUtils.setEntityIdValues(bean, idOrIdMap, model);
        int result = SqlBoxContextUtils.entityLoadTry(ctx, bean, optionItems);
        if (result != 1) {
            return null;
        }
        return bean;
    }

    public static boolean entityExist(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        long result;
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityBean.getClass());
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                Object value = ClassCacheUtils.readValueFromBeanField(entityBean, fieldName);
                if (!where.isEmpty()) {
                    where.append(" and ");
                }
                where.append(JDBPRO.param(value));
                where.append(col.getColumnName()).append("=? ");
                if (col.getShardTable() != null) {
                    shardTableItem = JSQLBOX.shardTB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                }
                if (col.getShardDatabase() == null) continue;
                shardDbItem = JSQLBOX.shardDB(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
                continue;
            }
            SqlBoxContextUtils.notAllowSharding(col);
        }
        if (where.isEmpty()) {
            throw new SqlBoxException("No primary key found for entityBean");
        }
        jSQL.append("select count(1) from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        if ((result = ctx.iQueryForLongValue(jSQL.toObjectArray())) == 1L) {
            return true;
        }
        if (result == 0L) {
            return false;
        }
        throw new SqlBoxException("Fail to check entity exist because found " + result + " records exist");
    }

    public static boolean entityExistById(SqlBoxContext ctx, Class<?> entityClass, Object id, Object ... optionItems) {
        long result;
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityClass);
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                Object value = EntityIdUtils.readFeidlValueFromEntityId(id, model, fieldName);
                if (!where.isEmpty()) {
                    where.append(" and ");
                }
                where.append(JDBPRO.param(value));
                where.append(col.getColumnName()).append("=? ");
                if (col.getShardTable() != null) {
                    shardTableItem = JSQLBOX.shardTB(EntityIdUtils.readFeidlValueFromEntityId(id, model, fieldName));
                }
                if (col.getShardDatabase() == null) continue;
                shardDbItem = JSQLBOX.shardDB(EntityIdUtils.readFeidlValueFromEntityId(id, model, fieldName));
                continue;
            }
            SqlBoxContextUtils.notAllowSharding(col);
        }
        if (where.isEmpty()) {
            throw new SqlBoxException("No primary key found for entityBean");
        }
        jSQL.append("select count(1) from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        if ((result = ctx.iQueryForLongValue(jSQL.toObjectArray())) == 1L) {
            return true;
        }
        if (result == 0L) {
            return false;
        }
        throw new SqlBoxException("Fail to check entity exist because found " + result + " rows record in database");
    }

    public static int entityCountAll(SqlBoxContext ctx, Class<?> entityClass, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        Map<String, Method> writeMethods = ClassCacheUtils.getClassWriteMethods(entityClass);
        for (String fieldName : writeMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue() || col.getShardTable() == null && col.getShardDatabase() == null) continue;
            throw new SqlBoxException("Fail to count entity quantity because sharding columns exist.");
        }
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        jSQL.append("select count(1) from ").append(model.getTableName());
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        return ((Number)ctx.iQueryForObject(jSQL.toObjectArray())).intValue();
    }

    public static <T> List<T> entityFindAll(SqlBoxContext ctx, Class<T> entityClass, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        ArrayList<String> allFieldNames = new ArrayList<String>();
        Map<String, Method> writeMethods = ClassCacheUtils.getClassWriteMethods(entityClass);
        for (String fieldName : writeMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue()) continue;
            if (col.getShardTable() != null || col.getShardDatabase() != null) {
                throw new SqlBoxException("Fail to load all entity because sharding columns exist.");
            }
            jSQL.append(col.getColumnName()).append(", ");
            allFieldNames.add(col.getEntityField());
        }
        jSQL.remove(jSQL.size() - 1);
        jSQL.frontAdd("select ").append(" from ");
        jSQL.append(model.getTableName());
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        jSQL.append(SingleTonHandlers.arrayListHandler);
        List valuesList = (List)ctx.iQuery(jSQL.toObjectArray());
        ArrayList<T> result = new ArrayList<T>();
        if (valuesList == null || valuesList.isEmpty()) {
            return result;
        }
        for (Object[] values : valuesList) {
            T bean = SqlBoxContextUtils.entityOrClassToBean(entityClass);
            try {
                for (int i = 0; i < values.length; ++i) {
                    Method writeMethod = writeMethods.get(allFieldNames.get(i));
                    SqlBoxException.assureNotNull(writeMethod, "Not found write method of field '" + (String)allFieldNames.get(i) + "' in " + bean.getClass());
                    writeMethod.invoke(bean, values[i]);
                }
            }
            catch (Exception e) {
                throw new SqlBoxException(e);
            }
            result.add(bean);
        }
        return result;
    }

    public static <T> List<T> entityFindByIds(SqlBoxContext ctx, Class<T> entityClass, Iterable<?> ids, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        ArrayList<String> allFieldNames = new ArrayList<String>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> writeMethods = ClassCacheUtils.getClassWriteMethods(entityClass);
        for (String fieldName : writeMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                List<Object> oneFieldValues = EntityIdUtils.getOnlyOneFieldFromIds(ids, model, fieldName);
                where.append(col.getColumnName()).append(" in (");
                for (int i = 0; i < oneFieldValues.size(); ++i) {
                    if (i != 0) {
                        where.append(",");
                    }
                    where.append("?");
                    where.append(JDBPRO.param(oneFieldValues.get(i)));
                }
                where.append(")");
                if (col.getShardTable() != null) {
                    shardTableItem = JSQLBOX.shardTB(oneFieldValues);
                }
                if (col.getShardDatabase() != null) {
                    shardDbItem = JSQLBOX.shardDB(oneFieldValues);
                }
                where.append(" and ");
            } else {
                SqlBoxContextUtils.notAllowSharding(col);
            }
            jSQL.append(col.getColumnName()).append(", ");
            allFieldNames.add(col.getEntityField());
        }
        jSQL.remove(jSQL.size() - 1);
        if (where.isEmpty()) {
            throw new SqlBoxException("No PKey column found from tableModel '" + model.getTableName() + "'");
        }
        where.remove(where.size() - 1);
        jSQL.frontAdd("select ").append(" from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        if (optionModel == null) {
            jSQL.frontAdd(model);
        }
        jSQL.append(SingleTonHandlers.arrayListHandler);
        List valuesList = (List)ctx.iQuery(jSQL.toObjectArray());
        ArrayList<T> result = new ArrayList<T>();
        if (valuesList == null || valuesList.isEmpty()) {
            return result;
        }
        for (Object[] values : valuesList) {
            T bean = SqlBoxContextUtils.entityOrClassToBean(entityClass);
            try {
                for (int i = 0; i < values.length; ++i) {
                    Method writeMethod = writeMethods.get(allFieldNames.get(i));
                    SqlBoxException.assureNotNull(writeMethod, "Not found write method of field '" + (String)allFieldNames.get(i) + "' in " + bean.getClass());
                    writeMethod.invoke(bean, values[i]);
                }
            }
            catch (Exception e) {
                throw new SqlBoxException(e);
            }
            result.add(bean);
        }
        return result;
    }

    public static <T> List<T> entityFindBySample(SqlBoxContext ctx, Object sampleBean, Object ... sqlItems) {
        return SqlBoxContextUtils.entityFindAll(ctx, sampleBean.getClass(), new SampleItem(sampleBean).sql(" where ").notNullFields(), sqlItems);
    }

    private static void ormQueryMethods___________________________________() {
    }

    public static EntityNet entityAutoNet(SqlBoxContext ctx, Class<?> ... entityClasses) {
        TableModel[] models = SqlBoxContextUtils.findAllModels(entityClasses);
        PreparedSQL ps = ctx.iPrepare(new Object[]{SqlOption.QUERY, new EntityNetHandler(), models, JSQLBOX.AUTO_SQL});
        SqlBoxException.assureTrue(ps.getAliases() != null && ps.getAliases().length > 1, new String[0]);
        String firstAlias = ps.getAliases()[0];
        for (int i = 1; i < entityClasses.length; ++i) {
            ps.giveBoth(firstAlias, ps.getAliases()[i]);
        }
        return (EntityNet)ctx.runPreparedSQL(ps);
    }

    public static <E> E entityFindRelatedOne(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        List<E> list = SqlBoxContextUtils.entityFindRelatedList(ctx, entity, sqlItems);
        if (list.size() != 1) {
            throw new SqlBoxException("Expect 1 entity but found " + list.size() + " records");
        }
        return list.get(0);
    }

    public static <E> List<E> entityFindRelatedList(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        if (sqlItems.length == 0) {
            throw new SqlBoxException("Target entity class is required");
        }
        for (Object item : sqlItems) {
            if (!(item instanceof EntityNet)) continue;
            return ((EntityNet)item).findRelatedList(ctx, entity, sqlItems);
        }
        SqlBoxException.assureNotNull(entity, new String[0]);
        TableModel[] models = SqlBoxContextUtils.findAllModels(sqlItems);
        Object[] modelsAlias = SqlBoxContextUtils.findModelAlias(sqlItems);
        Object[] notModelAlias = SqlBoxContextUtils.findNotModelAlias(sqlItems);
        EntityNet net = (EntityNet)ctx.iQuery(new Object[]{SqlOption.QUERY, new EntityNetHandler(), modelsAlias, JSQLBOX.AUTO_SQL, " where ", new EntityKeyItem(entity), notModelAlias});
        return net.pickEntityList(models[models.length - 1].getEntityClass());
    }

    public static <E> Set<E> entityFindRelatedSet(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        if (sqlItems.length == 0) {
            throw new SqlBoxException("Target entity class is required");
        }
        for (Object item : sqlItems) {
            if (!(item instanceof EntityNet)) continue;
            return ((EntityNet)item).findRelatedSet(ctx, entity, sqlItems);
        }
        TableModel[] models = SqlBoxContextUtils.findAllModels(sqlItems);
        Object[] modelsAlias = SqlBoxContextUtils.findModelAlias(sqlItems);
        Object[] notModelAlias = SqlBoxContextUtils.findNotModelAlias(sqlItems);
        EntityNet net = (EntityNet)ctx.iQuery(new Object[]{SqlOption.QUERY, new EntityNetHandler(), modelsAlias, JSQLBOX.AUTO_SQL, " where ", new EntityKeyItem(entity), notModelAlias});
        return net.pickEntitySet(models[models.length - 1].getEntityClass());
    }

    public static <E> Map<Object, E> entityFindRelatedMap(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        if (sqlItems.length == 0) {
            throw new SqlBoxException("Target entity class is required");
        }
        for (Object item : sqlItems) {
            if (!(item instanceof EntityNet)) continue;
            return ((EntityNet)item).findRelatedMap(ctx, entity, sqlItems);
        }
        TableModel[] models = SqlBoxContextUtils.findAllModels(sqlItems);
        Object[] modelsAlias = SqlBoxContextUtils.findModelAlias(sqlItems);
        Object[] notModelAlias = SqlBoxContextUtils.findNotModelAlias(sqlItems);
        EntityNet net = (EntityNet)ctx.iQuery(new Object[]{SqlOption.QUERY, new EntityNetHandler(), modelsAlias, JSQLBOX.AUTO_SQL, " where ", new EntityKeyItem(entity), notModelAlias});
        return net.pickEntityMap(models[models.length - 1].getEntityClass());
    }
}

