/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.TextUtils;
import com.github.drinkjava2.jsqlbox.annotation.Alias;
import com.github.drinkjava2.jsqlbox.annotation.Ioc;
import com.github.drinkjava2.jsqlbox.annotation.Model;
import com.github.drinkjava2.jsqlbox.annotation.New;
import com.github.drinkjava2.jsqlbox.annotation.Sql;
import com.github.drinkjava2.jsqlbox.compiler.DynamicCompileEngine;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SqlMapperUtils {
    public static final String CHILD_SUFFIX = "_Child";
    private static final Map<String, String[]> methodParamNamesCache = new ConcurrentHashMap<String, String[]>();

    public static Class<?> createChildClass(Class<?> abstractClass) {
        String fullClassName = abstractClass.getName() + CHILD_SUFFIX;
        Class<?> check = ClassCacheUtils.checkClassExist(fullClassName);
        if (check != null) {
            return check;
        }
        String src = TextUtils.getJavaSourceCodeUTF8(abstractClass);
        if (StrUtils.isEmpty(src)) {
            throw new SqlBoxException("No Java source code found for class '" + abstractClass.getName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        String start = StrUtils.substringBefore(src, "public abstract class " + abstractClass.getSimpleName());
        if (StrUtils.isEmpty(start)) {
            throw new SqlBoxException("AbstractActiveRecord Java source code should have a 'public abstract class " + abstractClass.getSimpleName() + "' ");
        }
        sb.append(start);
        sb.append("public class ").append(abstractClass.getSimpleName()).append("_Child extends ").append(abstractClass.getSimpleName()).append("{");
        String body = StrUtils.substringAfter(src, "public abstract class " + abstractClass.getSimpleName());
        body = StrUtils.substringAfter(body, "{");
        String heading = StrUtils.substringAfter(body, "public abstract ");
        while (!StrUtils.isEmpty(heading)) {
            start = StrUtils.substringBefore(body, "public abstract ");
            sb.append(start).append("public ");
            String title = StrUtils.substringBefore(heading, ";").trim();
            sb.append(title).append("{");
            if (!title.startsWith("void ")) {
                sb.append(" return ");
            }
            if (title.indexOf("PreparedSQL ") > -1) {
                sb.append("this.guessPreparedSQL(");
            } else {
                sb.append("this.guess(");
            }
            String paramStr = StrUtils.substringAfter(title, "(");
            paramStr = StrUtils.substringBeforeLast(paramStr, ")");
            String[] params = StrUtils.split(paramStr, ',');
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                String trimedStr = params[i].trim();
                String pm = StrUtils.substringAfterLast(trimedStr, " ");
                sb.append("bind(\"").append(pm).append("\", ").append(pm).append(")");
            }
            sb.append(");}");
            body = StrUtils.substringAfter(heading, ";");
            heading = StrUtils.substringAfter(body, "public abstract ");
        }
        sb.append(body);
        String childClassSrc = sb.toString();
        Class<?> childClass = null;
        childClass = DynamicCompileEngine.instance.javaCodeToClass(fullClassName, childClassSrc);
        ClassCacheUtils.registerClass(childClass);
        TextUtils.javaFileCache.put(fullClassName, childClassSrc);
        return childClass;
    }

    public static Map<String, Object> buildParamMap(String callerClassName, String callerMethodName, Object ... params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] methodParamNames = SqlMapperUtils.getMethodParamNames(callerClassName, callerMethodName);
        if (methodParamNames != null && methodParamNames.length > 0) {
            for (int i = 0; i < methodParamNames.length; ++i) {
                map.put(methodParamNames[i], params[i]);
            }
        }
        return map;
    }

    public static String[] getMethodParamNames(String classFullName, String callerMethodName) {
        String key = classFullName + "@#!$^" + callerMethodName;
        if (methodParamNamesCache.containsKey(key)) {
            return methodParamNamesCache.get(key);
        }
        String src = TextUtils.getJavaSourceCodeUTF8(classFullName);
        src = StrUtils.substringBetween(src, callerMethodName + "(", "}");
        src = StrUtils.substringBetween(src, "guess(", ")");
        String[] result = StrUtils.split(src, ',');
        ArrayList<String> l = new ArrayList<String>();
        if (result != null) {
            for (String str : result) {
                String trimed = str.trim();
                if (StrUtils.isEmpty(trimed)) continue;
                l.add(trimed);
            }
        }
        methodParamNamesCache.put(key, l.toArray(new String[l.size()]));
        return l.toArray(new String[l.size()]);
    }

    public static String getSqlOfMethod(String callerClassName, Method callerMethod) {
        Annotation[] annos;
        for (Annotation anno : annos = callerMethod.getAnnotations()) {
            if (!Sql.class.equals(anno.annotationType())) continue;
            StringBuilder sb = new StringBuilder();
            for (String s : ((Sql)anno).value()) {
                sb.append(s);
            }
            return sb.toString();
        }
        String sql = null;
        String src = null;
        try {
            src = TextUtils.getJavaSourceCodeUTF8(callerClassName);
            sql = StrUtils.substringAfter(src, callerMethod.getName() + "(");
            sql = StrUtils.substringBetween(sql, "/*-", "*/");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sql != null) {
            sql = sql.trim();
        }
        return sql;
    }

    public static void dealNewIocModelAliasAnnotation(List<Object> realParamList, Method callerMethod) {
        Annotation[] annos;
        for (Annotation anno : annos = callerMethod.getAnnotations()) {
            Class<?>[] array;
            Class<? extends Annotation> annoType = anno.annotationType();
            if (New.class.equals(annoType)) {
                array = ((New)anno).value();
                for (Class<?> clazz : array) {
                    try {
                        realParamList.add(clazz.newInstance());
                    }
                    catch (Exception e) {
                        throw new SqlBoxException(e);
                    }
                }
                continue;
            }
            if (Ioc.class.equals(annoType)) {
                array = ((Ioc)anno).value();
                for (Class<?> clazz : array) {
                    realParamList.add(new SqlItem(SqlOption.IOC, clazz));
                }
                continue;
            }
            if (Model.class.equals(annoType)) {
                array = ((Model)anno).value();
                for (Class<?> clazz : array) {
                    realParamList.add(clazz);
                }
                continue;
            }
            if (!Alias.class.equals(annoType)) continue;
            String[] aliases = ((Alias)anno).value();
            for (String string : aliases) {
                realParamList.add(new SqlItem(SqlOption.ALIAS, string));
            }
        }
    }
}

