/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.tinytx;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TinyTxLogger {
    private Object commonLogger;
    private Method commonLoggerInfoMethod;
    private Method commonLoggerWarnMethod;
    private Method commonLoggerErrorMethod;
    private Logger jdkLogger;
    private static boolean firstRun = true;
    private static boolean enableLog = true;
    public static TinyTxLogger INSTANCE = null;

    public TinyTxLogger(Class<?> targetClass) {
        if (targetClass == null) {
            throw new AssertionError((Object)"TinyTxLogger error: targetClass can not be null.");
        }
        try {
            Class<?> logFactoryClass = Class.forName("org.apache.commons.logging.LogFactory");
            Method method = logFactoryClass.getMethod("getLog", Class.class);
            this.commonLogger = method.invoke(logFactoryClass, targetClass);
            this.commonLoggerInfoMethod = this.commonLogger.getClass().getMethod("info", Object.class);
            this.commonLoggerWarnMethod = this.commonLogger.getClass().getMethod("warn", Object.class);
            this.commonLoggerErrorMethod = this.commonLogger.getClass().getMethod("error", Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.commonLogger == null || this.commonLoggerWarnMethod == null) {
            if (firstRun) {
                System.err.println("TinyTxLogger failed to load org.apache.commons.logging.LogFactory. Use JDK logger.");
            }
            this.jdkLogger = Logger.getLogger(targetClass.getName());
        } else if (firstRun) {
            System.out.println("org.apache.commons.logging.LogFactory loaded, DbProLogger use it as logger.");
        }
    }

    public static TinyTxLogger getLog(Class<?> targetClass) {
        return new TinyTxLogger(targetClass);
    }

    public static void setEnableLog(boolean enablelog) {
        enableLog = enablelog;
    }

    public void info(String msg) {
        if (!enableLog) {
            return;
        }
        if (this.jdkLogger != null) {
            this.jdkLogger.log(Level.INFO, msg);
            return;
        }
        try {
            this.commonLoggerInfoMethod.invoke(this.commonLogger, msg);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public void warn(String msg) {
        if (!enableLog) {
            return;
        }
        if (this.jdkLogger != null) {
            this.jdkLogger.log(Level.WARNING, msg);
            return;
        }
        try {
            this.commonLoggerWarnMethod.invoke(this.commonLogger, msg);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public void error(String msg) {
        if (!enableLog) {
            return;
        }
        if (this.jdkLogger != null) {
            this.jdkLogger.log(Level.SEVERE, msg);
            return;
        }
        try {
            this.commonLoggerErrorMethod.invoke(this.commonLogger, msg);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    static {
        INSTANCE = new TinyTxLogger(TinyTxLogger.class);
        firstRun = false;
    }
}

