/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.phoenixframework.Channel;
import org.phoenixframework.Defaults;
import org.phoenixframework.DispatchQueue;
import org.phoenixframework.DispatchWorkItem;
import org.phoenixframework.Message;
import org.phoenixframework.ScheduledDispatchQueue;
import org.phoenixframework.StateChangeCallbacks;
import org.phoenixframework.TimeoutTimer;
import org.phoenixframework.Transport;
import org.phoenixframework.WebSocketTransport;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001BC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\b\u0002\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012&\u0010\f\u001a\"\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\rj\u0002`\u000e\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010q\u001a\u00020@2\u0006\u0010r\u001a\u00020\u0003H\u0002J*\u0010s\u001a\u00020\u00122\u0006\u0010t\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005j\u0002`\u0006J\u0006\u0010u\u001a\u00020@J.\u0010v\u001a\u00020@2\b\b\u0002\u0010w\u001a\u00020N2\n\b\u0002\u0010r\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010x\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010\rJ\r\u0010y\u001a\u00020@H\u0000\u00a2\u0006\u0002\bzJ\u0015\u0010{\u001a\u00020@2\u0006\u0010t\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b|J\u000e\u0010}\u001a\u00020@2\u0006\u0010~\u001a\u00020\u0003J\u000e\u0010\u007f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0003\b\u0080\u0001J\u0016\u0010\u0081\u0001\u001a\u00020@2\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011J\u0015\u0010\u0083\u0001\u001a\u00020\u00032\f\u0010x\u001a\b\u0012\u0004\u0012\u00020@0\rJ\u0017\u0010\u0084\u0001\u001a\u00020@2\u0006\u0010w\u001a\u00020NH\u0000\u00a2\u0006\u0003\b\u0085\u0001J%\u0010\u0086\u0001\u001a\u00020@2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0018\u0010\u008c\u0001\u001a\u00020@2\u0007\u0010\u008d\u0001\u001a\u00020\u0003H\u0000\u00a2\u0006\u0003\b\u008e\u0001J\u000f\u0010\u008f\u0001\u001a\u00020@H\u0000\u00a2\u0006\u0003\b\u0090\u0001J&\u0010\u0091\u0001\u001a\u00020\u00032\u001d\u0010x\u001a\u0019\u0012\u0005\u0012\u00030\u0088\u0001\u0012\u0007\u0012\u0005\u0018\u00010\u008a\u0001\u0012\u0004\u0012\u00020@0\u0092\u0001J\u001c\u0010\u0093\u0001\u001a\u00020\u00032\u0013\u0010x\u001a\u000f\u0012\u0005\u0012\u00030\u0094\u0001\u0012\u0004\u0012\u00020@0?J\u0015\u0010\u0095\u0001\u001a\u00020\u00032\f\u0010x\u001a\b\u0012\u0004\u0012\u00020@0\rJT\u0010\u0096\u0001\u001a\u00020@2\u0006\u0010t\u001a\u00020\u00032\u0007\u0010\u0097\u0001\u001a\u00020\u00032\u0019\u0010\u0098\u0001\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005j\u0002`\u00062\n\b\u0002\u0010W\u001a\u0004\u0018\u00010\u00032\u000b\b\u0002\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0003\b\u009a\u0001J\u000f\u0010\u009b\u0001\u001a\u00020@2\u0006\u0010s\u001a\u00020\u0012J\u0007\u0010\u009c\u0001\u001a\u00020@J\u0017\u0010\u009d\u0001\u001a\u00020@2\u0006\u0010W\u001a\u00020\u0003H\u0000\u00a2\u0006\u0003\b\u009e\u0001J\u000f\u0010\u009f\u0001\u001a\u00020@H\u0000\u00a2\u0006\u0003\b\u00a0\u0001J\u000f\u0010\u00a1\u0001\u001a\u00020@H\u0000\u00a2\u0006\u0003\b\u00a2\u0001J1\u0010\u00a3\u0001\u001a\u00020@2\b\b\u0002\u0010w\u001a\u00020N2\n\b\u0002\u0010r\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010x\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010\rH\u0002J\t\u0010\u00a4\u0001\u001a\u00020@H\u0002R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001e\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001c\u00107\u001a\u0004\u0018\u000108X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u001aR(\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020@\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR1\u0010\f\u001a\"\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\rj\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u001c\u0010G\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010+\"\u0004\bI\u0010JR\u0011\u0010K\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bL\u0010+R&\u0010M\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u0002020?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010B\"\u0004\bP\u0010DR\u001a\u0010Q\u001a\u00020RX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u001a\u0010W\u001a\u00020NX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R&\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u0002020?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010B\"\u0004\b^\u0010DR4\u0010_\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0\r0a0`X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\u0014\"\u0004\bc\u0010\u0016R\u001a\u0010d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\u001a\"\u0004\bf\u0010\u001cR\u0014\u0010g\u001a\u00020hX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010jR\u001a\u0010k\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u00104\"\u0004\bm\u00106R&\u0010n\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001e0?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010B\"\u0004\bp\u0010D\u00a8\u0006\u00a5\u0001"}, d2={"Lorg/phoenixframework/Socket;", "", "url", "", "params", "", "Lorg/phoenixframework/Payload;", "gson", "Lcom/google/gson/Gson;", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Ljava/util/Map;Lcom/google/gson/Gson;Lokhttp3/OkHttpClient;)V", "paramsClosure", "Lkotlin/Function0;", "Lorg/phoenixframework/PayloadClosure;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lcom/google/gson/Gson;Lokhttp3/OkHttpClient;)V", "channels", "", "Lorg/phoenixframework/Channel;", "getChannels$JavaPhoenixClient", "()Ljava/util/List;", "setChannels$JavaPhoenixClient", "(Ljava/util/List;)V", "closeWasClean", "", "getCloseWasClean$JavaPhoenixClient", "()Z", "setCloseWasClean$JavaPhoenixClient", "(Z)V", "connection", "Lorg/phoenixframework/Transport;", "getConnection$JavaPhoenixClient", "()Lorg/phoenixframework/Transport;", "setConnection$JavaPhoenixClient", "(Lorg/phoenixframework/Transport;)V", "dispatchQueue", "Lorg/phoenixframework/DispatchQueue;", "getDispatchQueue$JavaPhoenixClient", "()Lorg/phoenixframework/DispatchQueue;", "setDispatchQueue$JavaPhoenixClient", "(Lorg/phoenixframework/DispatchQueue;)V", "endpoint", "getEndpoint", "()Ljava/lang/String;", "<set-?>", "Ljava/net/URL;", "endpointUrl", "getEndpointUrl", "()Ljava/net/URL;", "heartbeatIntervalMs", "", "getHeartbeatIntervalMs", "()J", "setHeartbeatIntervalMs", "(J)V", "heartbeatTask", "Lorg/phoenixframework/DispatchWorkItem;", "getHeartbeatTask$JavaPhoenixClient", "()Lorg/phoenixframework/DispatchWorkItem;", "setHeartbeatTask$JavaPhoenixClient", "(Lorg/phoenixframework/DispatchWorkItem;)V", "isConnected", "logger", "Lkotlin/Function1;", "", "getLogger", "()Lkotlin/jvm/functions/Function1;", "setLogger", "(Lkotlin/jvm/functions/Function1;)V", "getParamsClosure", "()Lkotlin/jvm/functions/Function0;", "pendingHeartbeatRef", "getPendingHeartbeatRef$JavaPhoenixClient", "setPendingHeartbeatRef$JavaPhoenixClient", "(Ljava/lang/String;)V", "protocol", "getProtocol", "reconnectAfterMs", "", "getReconnectAfterMs", "setReconnectAfterMs", "reconnectTimer", "Lorg/phoenixframework/TimeoutTimer;", "getReconnectTimer$JavaPhoenixClient", "()Lorg/phoenixframework/TimeoutTimer;", "setReconnectTimer$JavaPhoenixClient", "(Lorg/phoenixframework/TimeoutTimer;)V", "ref", "getRef$JavaPhoenixClient", "()I", "setRef$JavaPhoenixClient", "(I)V", "rejoinAfterMs", "getRejoinAfterMs", "setRejoinAfterMs", "sendBuffer", "", "Lkotlin/Pair;", "getSendBuffer$JavaPhoenixClient", "setSendBuffer$JavaPhoenixClient", "skipHeartbeat", "getSkipHeartbeat", "setSkipHeartbeat", "stateChangeCallbacks", "Lorg/phoenixframework/StateChangeCallbacks;", "getStateChangeCallbacks$JavaPhoenixClient", "()Lorg/phoenixframework/StateChangeCallbacks;", "timeout", "getTimeout", "setTimeout", "transport", "getTransport$JavaPhoenixClient", "setTransport$JavaPhoenixClient", "abnormalClose", "reason", "channel", "topic", "connect", "disconnect", "code", "callback", "flushSendBuffer", "flushSendBuffer$JavaPhoenixClient", "leaveOpenTopic", "leaveOpenTopic$JavaPhoenixClient", "logItems", "body", "makeRef", "makeRef$JavaPhoenixClient", "off", "refs", "onClose", "onConnectionClosed", "onConnectionClosed$JavaPhoenixClient", "onConnectionError", "t", "", "response", "Lokhttp3/Response;", "onConnectionError$JavaPhoenixClient", "onConnectionMessage", "rawMessage", "onConnectionMessage$JavaPhoenixClient", "onConnectionOpened", "onConnectionOpened$JavaPhoenixClient", "onError", "Lkotlin/Function2;", "onMessage", "Lorg/phoenixframework/Message;", "onOpen", "push", "event", "payload", "joinRef", "push$JavaPhoenixClient", "remove", "removeAllCallbacks", "removeFromSendBuffer", "removeFromSendBuffer$JavaPhoenixClient", "resetHeartbeat", "resetHeartbeat$JavaPhoenixClient", "sendHeartbeat", "sendHeartbeat$JavaPhoenixClient", "teardown", "triggerChannelError", "JavaPhoenixClient"})
public final class Socket {
    @NotNull
    private final String endpoint;
    @NotNull
    private URL endpointUrl;
    private long timeout;
    private long heartbeatIntervalMs;
    @NotNull
    private Function1<? super Integer, Long> reconnectAfterMs;
    @NotNull
    private Function1<? super Integer, Long> rejoinAfterMs;
    @Nullable
    private Function1<? super String, Unit> logger;
    private boolean skipHeartbeat;
    @NotNull
    private DispatchQueue dispatchQueue;
    @NotNull
    private Function1<? super URL, ? extends Transport> transport;
    @NotNull
    private final StateChangeCallbacks stateChangeCallbacks;
    @NotNull
    private List<Channel> channels;
    @NotNull
    private List<Pair<String, Function0<Unit>>> sendBuffer;
    private int ref;
    @Nullable
    private DispatchWorkItem heartbeatTask;
    @Nullable
    private String pendingHeartbeatRef;
    @NotNull
    private TimeoutTimer reconnectTimer;
    private boolean closeWasClean;
    @Nullable
    private Transport connection;
    @NotNull
    private final Function0<Map<String, Object>> paramsClosure;
    private final Gson gson;
    private final OkHttpClient client;

    @NotNull
    public final String getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public final URL getEndpointUrl() {
        return this.endpointUrl;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long l) {
        this.timeout = l;
    }

    public final long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public final void setHeartbeatIntervalMs(long l) {
        this.heartbeatIntervalMs = l;
    }

    @NotNull
    public final Function1<Integer, Long> getReconnectAfterMs() {
        return this.reconnectAfterMs;
    }

    public final void setReconnectAfterMs(@NotNull Function1<? super Integer, Long> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.reconnectAfterMs = function1;
    }

    @NotNull
    public final Function1<Integer, Long> getRejoinAfterMs() {
        return this.rejoinAfterMs;
    }

    public final void setRejoinAfterMs(@NotNull Function1<? super Integer, Long> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.rejoinAfterMs = function1;
    }

    @Nullable
    public final Function1<String, Unit> getLogger() {
        return this.logger;
    }

    public final void setLogger(@Nullable Function1<? super String, Unit> function1) {
        this.logger = function1;
    }

    public final boolean getSkipHeartbeat() {
        return this.skipHeartbeat;
    }

    public final void setSkipHeartbeat(boolean bl) {
        this.skipHeartbeat = bl;
    }

    @NotNull
    public final DispatchQueue getDispatchQueue$JavaPhoenixClient() {
        return this.dispatchQueue;
    }

    public final void setDispatchQueue$JavaPhoenixClient(@NotNull DispatchQueue dispatchQueue) {
        Intrinsics.checkParameterIsNotNull((Object)dispatchQueue, (String)"<set-?>");
        this.dispatchQueue = dispatchQueue;
    }

    @NotNull
    public final Function1<URL, Transport> getTransport$JavaPhoenixClient() {
        return this.transport;
    }

    public final void setTransport$JavaPhoenixClient(@NotNull Function1<? super URL, ? extends Transport> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.transport = function1;
    }

    @NotNull
    public final StateChangeCallbacks getStateChangeCallbacks$JavaPhoenixClient() {
        return this.stateChangeCallbacks;
    }

    @NotNull
    public final List<Channel> getChannels$JavaPhoenixClient() {
        return this.channels;
    }

    public final void setChannels$JavaPhoenixClient(@NotNull List<Channel> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.channels = list2;
    }

    @NotNull
    public final List<Pair<String, Function0<Unit>>> getSendBuffer$JavaPhoenixClient() {
        return this.sendBuffer;
    }

    public final void setSendBuffer$JavaPhoenixClient(@NotNull List<Pair<String, Function0<Unit>>> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.sendBuffer = list2;
    }

    public final int getRef$JavaPhoenixClient() {
        return this.ref;
    }

    public final void setRef$JavaPhoenixClient(int n) {
        this.ref = n;
    }

    @Nullable
    public final DispatchWorkItem getHeartbeatTask$JavaPhoenixClient() {
        return this.heartbeatTask;
    }

    public final void setHeartbeatTask$JavaPhoenixClient(@Nullable DispatchWorkItem dispatchWorkItem) {
        this.heartbeatTask = dispatchWorkItem;
    }

    @Nullable
    public final String getPendingHeartbeatRef$JavaPhoenixClient() {
        return this.pendingHeartbeatRef;
    }

    public final void setPendingHeartbeatRef$JavaPhoenixClient(@Nullable String string) {
        this.pendingHeartbeatRef = string;
    }

    @NotNull
    public final TimeoutTimer getReconnectTimer$JavaPhoenixClient() {
        return this.reconnectTimer;
    }

    public final void setReconnectTimer$JavaPhoenixClient(@NotNull TimeoutTimer timeoutTimer) {
        Intrinsics.checkParameterIsNotNull((Object)timeoutTimer, (String)"<set-?>");
        this.reconnectTimer = timeoutTimer;
    }

    public final boolean getCloseWasClean$JavaPhoenixClient() {
        return this.closeWasClean;
    }

    public final void setCloseWasClean$JavaPhoenixClient(boolean bl) {
        this.closeWasClean = bl;
    }

    @Nullable
    public final Transport getConnection$JavaPhoenixClient() {
        return this.connection;
    }

    public final void setConnection$JavaPhoenixClient(@Nullable Transport transport2) {
        this.connection = transport2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getProtocol() {
        String string = this.endpointUrl.getProtocol();
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 3213448: {
                    if (!string2.equals("http")) break;
                    return "ws";
                }
                case 99617003: {
                    if (!string2.equals("https")) break;
                    return "wss";
                }
            }
        }
        String string3 = this.endpointUrl.getProtocol();
        String string4 = string3;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"endpointUrl.protocol");
        return string4;
    }

    public final boolean isConnected() {
        Transport transport2 = this.connection;
        return (transport2 != null ? transport2.getReadyState() : null) == Transport.ReadyState.OPEN;
    }

    public final void connect() {
        block5: {
            if (this.isConnected()) {
                return;
            }
            this.closeWasClean = false;
            this.endpointUrl = Defaults.INSTANCE.buildEndpointUrl$JavaPhoenixClient(this.endpoint, this.paramsClosure);
            Transport transport2 = this.connection = (Transport)this.transport.invoke((Object)this.endpointUrl);
            if (transport2 != null) {
                transport2.setOnOpen((Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ Socket this$0;

                    public final void invoke() {
                        this.this$0.onConnectionOpened$JavaPhoenixClient();
                    }
                    {
                        this.this$0 = socket;
                        super(0);
                    }
                }));
            }
            Transport transport3 = this.connection;
            if (transport3 != null) {
                transport3.setOnClose((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
                    final /* synthetic */ Socket this$0;

                    public final void invoke(int code) {
                        this.this$0.onConnectionClosed$JavaPhoenixClient(code);
                    }
                    {
                        this.this$0 = socket;
                        super(1);
                    }
                }));
            }
            Transport transport4 = this.connection;
            if (transport4 != null) {
                transport4.setOnError((Function2<? super Throwable, ? super Response, Unit>)((Function2)new Function2<Throwable, Response, Unit>(this){
                    final /* synthetic */ Socket this$0;

                    public final void invoke(@NotNull Throwable t, @Nullable Response r) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        this.this$0.onConnectionError$JavaPhoenixClient(t, r);
                    }
                    {
                        this.this$0 = socket;
                        super(2);
                    }
                }));
            }
            Transport transport5 = this.connection;
            if (transport5 != null) {
                transport5.setOnMessage((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ Socket this$0;

                    public final void invoke(@NotNull String m) {
                        Intrinsics.checkParameterIsNotNull((Object)m, (String)"m");
                        this.this$0.onConnectionMessage$JavaPhoenixClient(m);
                    }
                    {
                        this.this$0 = socket;
                        super(1);
                    }
                }));
            }
            Transport transport6 = this.connection;
            if (transport6 == null) break block5;
            transport6.connect();
        }
    }

    public final void disconnect(int code, @Nullable String reason, @Nullable Function0<Unit> callback2) {
        this.closeWasClean = true;
        this.reconnectTimer.reset();
        this.teardown(code, reason, callback2);
    }

    public static /* synthetic */ void disconnect$default(Socket socket, int n, String string, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            function0 = null;
        }
        socket.disconnect(n, string, (Function0<Unit>)function0);
    }

    @NotNull
    public final String onOpen(@NotNull Function0<Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        String string = this.makeRef$JavaPhoenixClient();
        boolean bl = false;
        boolean bl2 = false;
        String $this$apply = string;
        boolean bl3 = false;
        this.stateChangeCallbacks.onOpen($this$apply, callback2);
        return string;
    }

    @NotNull
    public final String onClose(@NotNull Function0<Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        String string = this.makeRef$JavaPhoenixClient();
        boolean bl = false;
        boolean bl2 = false;
        String $this$apply = string;
        boolean bl3 = false;
        this.stateChangeCallbacks.onClose($this$apply, callback2);
        return string;
    }

    @NotNull
    public final String onError(@NotNull Function2<? super Throwable, ? super Response, Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        String string = this.makeRef$JavaPhoenixClient();
        boolean bl = false;
        boolean bl2 = false;
        String $this$apply = string;
        boolean bl3 = false;
        this.stateChangeCallbacks.onError($this$apply, callback2);
        return string;
    }

    @NotNull
    public final String onMessage(@NotNull Function1<? super Message, Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        String string = this.makeRef$JavaPhoenixClient();
        boolean bl = false;
        boolean bl2 = false;
        String $this$apply = string;
        boolean bl3 = false;
        this.stateChangeCallbacks.onMessage($this$apply, callback2);
        return string;
    }

    public final void removeAllCallbacks() {
        this.stateChangeCallbacks.release();
    }

    @NotNull
    public final Channel channel(@NotNull String topic, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Channel channel = new Channel(topic, params, this);
        this.channels = CollectionsKt.plus((Collection)this.channels, (Object)channel);
        return channel;
    }

    @NotNull
    public static /* synthetic */ Channel channel$default(Socket socket, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        return socket.channel(string, map);
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(@NotNull Channel channel) {
        List list2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.off(channel.getStateChangeRefs$JavaPhoenixClient());
        Iterable iterable = this.channels;
        Socket socket = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Channel it = (Channel)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getJoinRef(), (Object)channel.getJoinRef()) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        socket.channels = list2 = (List)destination$iv$iv;
    }

    public final void off(@NotNull List<String> refs) {
        Intrinsics.checkParameterIsNotNull(refs, (String)"refs");
        this.stateChangeCallbacks.release(refs);
    }

    public final void push$JavaPhoenixClient(@NotNull String topic, @NotNull String event, @NotNull Map<String, ? extends Object> payload, @Nullable String ref, @Nullable String joinRef) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        Function0 callback2 = (Function0)new Function0<Unit>(this, topic, event, payload, ref, joinRef){
            final /* synthetic */ Socket this$0;
            final /* synthetic */ String $topic;
            final /* synthetic */ String $event;
            final /* synthetic */ Map $payload;
            final /* synthetic */ String $ref;
            final /* synthetic */ String $joinRef;

            public final void invoke() {
                block2: {
                    String it;
                    boolean bl;
                    boolean bl2;
                    boolean bl3 = false;
                    Map body = new LinkedHashMap<K, V>();
                    body.put("topic", this.$topic);
                    body.put("event", this.$event);
                    body.put("payload", this.$payload);
                    String string = this.$ref;
                    if (string != null) {
                        String string2 = string;
                        bl2 = false;
                        bl = false;
                        it = string2;
                        boolean bl4 = false;
                        body.put("ref", it);
                    }
                    String string3 = this.$joinRef;
                    if (string3 != null) {
                        String string4 = string3;
                        bl2 = false;
                        bl = false;
                        it = string4;
                        boolean bl5 = false;
                        body.put("join_ref", it);
                    }
                    String data = Socket.access$getGson$p(this.this$0).toJson((Object)body);
                    Transport transport2 = this.this$0.getConnection$JavaPhoenixClient();
                    if (transport2 == null) break block2;
                    Transport transport3 = transport2;
                    bl = false;
                    boolean bl6 = false;
                    Transport transport4 = transport3;
                    boolean bl7 = false;
                    this.this$0.logItems("Push: Sending " + data);
                    String string5 = data;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"data");
                    transport4.send(string5);
                }
            }
            {
                this.this$0 = socket;
                this.$topic = string;
                this.$event = string2;
                this.$payload = map;
                this.$ref = string3;
                this.$joinRef = string4;
                super(0);
            }
        };
        if (this.isConnected()) {
            callback2.invoke();
        } else {
            this.sendBuffer.add((Pair<String, Function0<Unit>>)new Pair((Object)ref, (Object)callback2));
        }
    }

    public static /* synthetic */ void push$JavaPhoenixClient$default(Socket socket, String string, String string2, Map map, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        socket.push$JavaPhoenixClient(string, string2, map, string3, string4);
    }

    @NotNull
    public final String makeRef$JavaPhoenixClient() {
        this.ref = this.ref == Integer.MAX_VALUE ? 0 : this.ref + 1;
        return String.valueOf(this.ref);
    }

    public final void logItems(@NotNull String body) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Function1<? super String, Unit> function1 = this.logger;
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)body);
        }
    }

    private final void teardown(int code, String reason, Function0<Unit> callback2) {
        block4: {
            Transport transport2 = this.connection;
            if (transport2 != null) {
                transport2.setOnClose((Function1<? super Integer, Unit>)((Function1)null));
            }
            Transport transport3 = this.connection;
            if (transport3 != null) {
                transport3.disconnect(code, reason);
            }
            this.connection = null;
            DispatchWorkItem dispatchWorkItem = this.heartbeatTask;
            if (dispatchWorkItem != null) {
                dispatchWorkItem.cancel();
            }
            this.heartbeatTask = null;
            Iterable $this$forEach$iv = this.stateChangeCallbacks.getClose();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                ((Function0)it.getSecond()).invoke();
            }
            Function0<Unit> function0 = callback2;
            if (function0 == null) break block4;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
    }

    static /* synthetic */ void teardown$default(Socket socket, int n, String string, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            function0 = null;
        }
        socket.teardown(n, string, (Function0<Unit>)function0);
    }

    private final void triggerChannelError() {
        Iterable $this$forEach$iv = this.channels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Channel channel = (Channel)element$iv;
            boolean bl = false;
            if (channel.isErrored() || channel.isLeaving() || channel.isClosed()) continue;
            Channel.trigger$JavaPhoenixClient$default(channel, Channel.Event.ERROR.getValue(), null, null, null, 14, null);
        }
    }

    public final void flushSendBuffer$JavaPhoenixClient() {
        if (this.isConnected()) {
            Collection collection = this.sendBuffer;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Iterable $this$forEach$iv = this.sendBuffer;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    ((Function0)it.getSecond()).invoke();
                }
                this.sendBuffer.clear();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeFromSendBuffer$JavaPhoenixClient(@NotNull String ref) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Iterable iterable = this.sendBuffer;
        Socket socket = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)ref) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        socket.sendBuffer = CollectionsKt.toMutableList((Collection)list2);
    }

    public final void leaveOpenTopic$JavaPhoenixClient(@NotNull String topic) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
                Iterable $this$firstOrNull$iv = this.channels;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Channel it = (Channel)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getTopic(), (Object)topic) && (it.isJoined() || it.isJoining()))) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Channel channel = v0;
            if (channel == null) break block2;
            Channel channel2 = channel;
            boolean bl = false;
            boolean bl2 = false;
            Channel it = channel2;
            boolean bl3 = false;
            this.logItems("Transport: Leaving duplicate topic: [" + topic + ']');
            Channel.leave$default(it, 0L, 1, null);
        }
    }

    public final void resetHeartbeat$JavaPhoenixClient() {
        this.pendingHeartbeatRef = null;
        DispatchWorkItem dispatchWorkItem = this.heartbeatTask;
        if (dispatchWorkItem != null) {
            dispatchWorkItem.cancel();
        }
        this.heartbeatTask = null;
        if (this.skipHeartbeat) {
            return;
        }
        long delay = this.heartbeatIntervalMs;
        long period = this.heartbeatIntervalMs;
        this.heartbeatTask = this.dispatchQueue.queueAtFixedRate(delay, period, TimeUnit.MILLISECONDS, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ Socket this$0;

            public final void invoke() {
                this.this$0.sendHeartbeat$JavaPhoenixClient();
            }
            {
                this.this$0 = socket;
                super(0);
            }
        }));
    }

    public final void sendHeartbeat$JavaPhoenixClient() {
        if (!this.isConnected()) {
            return;
        }
        String string = this.pendingHeartbeatRef;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.pendingHeartbeatRef = null;
            this.logItems("Transport: Heartbeat timeout. Attempt to re-establish connection");
            this.abnormalClose("heartbeat timeout");
            return;
        }
        this.pendingHeartbeatRef = this.makeRef$JavaPhoenixClient();
        String string3 = Channel.Event.HEARTBEAT.getValue();
        String string4 = "phoenix";
        Socket socket = this;
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        Socket.push$JavaPhoenixClient$default(socket, string4, string3, map, this.pendingHeartbeatRef, null, 16, null);
    }

    private final void abnormalClose(String reason) {
        block0: {
            this.closeWasClean = false;
            Transport transport2 = this.connection;
            if (transport2 == null) break block0;
            transport2.disconnect(1000, reason);
        }
    }

    public final void onConnectionOpened$JavaPhoenixClient() {
        this.logItems("Transport: Connected to " + this.endpoint);
        this.closeWasClean = false;
        this.flushSendBuffer$JavaPhoenixClient();
        this.reconnectTimer.reset();
        this.resetHeartbeat$JavaPhoenixClient();
        Iterable $this$forEach$iv = this.stateChangeCallbacks.getOpen();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            ((Function0)it.getSecond()).invoke();
        }
    }

    public final void onConnectionClosed$JavaPhoenixClient(int code) {
        this.logItems("Transport: close");
        this.triggerChannelError();
        DispatchWorkItem dispatchWorkItem = this.heartbeatTask;
        if (dispatchWorkItem != null) {
            dispatchWorkItem.cancel();
        }
        this.heartbeatTask = null;
        if (!this.closeWasClean) {
            this.reconnectTimer.scheduleTimeout();
        }
        Iterable $this$forEach$iv = this.stateChangeCallbacks.getClose();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            ((Function0)it.getSecond()).invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onConnectionMessage$JavaPhoenixClient(@NotNull String rawMessage) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)rawMessage, (String)"rawMessage");
        this.logItems("Receive: " + rawMessage);
        Message message = (Message)this.gson.fromJson(rawMessage, Message.class);
        if (Intrinsics.areEqual((Object)message.getRef(), (Object)this.pendingHeartbeatRef)) {
            this.pendingHeartbeatRef = null;
        }
        Iterable $this$filter$iv = this.channels;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Channel it = (Channel)element$iv$iv;
            boolean bl = false;
            Message message2 = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)message2, (String)"message");
            if (!it.isMember$JavaPhoenixClient(message2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Channel it = (Channel)element$iv;
            boolean bl = false;
            Message message3 = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)message3, (String)"message");
            it.trigger$JavaPhoenixClient(message3);
        }
        $this$forEach$iv = this.stateChangeCallbacks.getMessage();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Function1 function1 = (Function1)it.getSecond();
            Message message4 = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)message4, (String)"message");
            function1.invoke((Object)message4);
        }
    }

    public final void onConnectionError$JavaPhoenixClient(@NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        this.logItems("Transport: error " + t);
        this.triggerChannelError();
        Iterable $this$forEach$iv = this.stateChangeCallbacks.getError();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            ((Function2)it.getSecond()).invoke((Object)t, (Object)response);
        }
    }

    @NotNull
    public final Function0<Map<String, Object>> getParamsClosure() {
        return this.paramsClosure;
    }

    public Socket(@NotNull String url, @NotNull Function0<? extends Map<String, ? extends Object>> paramsClosure, @NotNull Gson gson, @NotNull OkHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(paramsClosure, (String)"paramsClosure");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.paramsClosure = paramsClosure;
        this.gson = gson;
        this.client = client;
        this.timeout = 10000L;
        this.heartbeatIntervalMs = 30000L;
        this.reconnectAfterMs = Defaults.INSTANCE.getReconnectSteppedBackOff();
        this.rejoinAfterMs = Defaults.INSTANCE.getRejoinSteppedBackOff();
        this.dispatchQueue = new ScheduledDispatchQueue(0, 1, null);
        this.transport = (Function1)new Function1<URL, WebSocketTransport>(this){
            final /* synthetic */ Socket this$0;

            @NotNull
            public final WebSocketTransport invoke(@NotNull URL it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new WebSocketTransport(it, Socket.access$getClient$p(this.this$0));
            }
            {
                this.this$0 = socket;
                super(1);
            }
        };
        this.stateChangeCallbacks = new StateChangeCallbacks();
        this.channels = new ArrayList();
        this.sendBuffer = new ArrayList();
        String mutableUrl = url;
        if (!StringsKt.contains$default((CharSequence)mutableUrl, (CharSequence)"/websocket", (boolean)false, (int)2, null)) {
            if (StringsKt.last((CharSequence)mutableUrl) != '/') {
                mutableUrl = mutableUrl + "/";
            }
            mutableUrl = mutableUrl + "websocket";
        }
        this.endpoint = mutableUrl;
        this.endpointUrl = Defaults.INSTANCE.buildEndpointUrl$JavaPhoenixClient(this.endpoint, this.paramsClosure);
        Function0 function0 = (Function0)new Function0<Unit>(){

            public final void invoke() {
                this.logItems("Socket attempting to reconnect");
                Socket.teardown$default(this, 0, null, (Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.connect();
                    }
                }, 3, null);
            }
        };
        Function1<? super Integer, Long> function1 = this.reconnectAfterMs;
        this.reconnectTimer = new TimeoutTimer(this.dispatchQueue, (Function0<Unit>)function0, function1);
    }

    public /* synthetic */ Socket(String string, Function0 function0, Gson gson, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            gson = Defaults.INSTANCE.getGson();
        }
        if ((n & 8) != 0) {
            OkHttpClient okHttpClient2 = new OkHttpClient.Builder().build();
            Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient2, (String)"OkHttpClient.Builder().build()");
            okHttpClient = okHttpClient2;
        }
        this(string, (Function0<? extends Map<String, ? extends Object>>)function0, gson, okHttpClient);
    }

    public Socket(@NotNull String url, final @Nullable Map<String, ? extends Object> params, @NotNull Gson gson, @NotNull OkHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this(url, (Function0<? extends Map<String, ? extends Object>>)((Function0)new Function0<Map<String, ? extends Object>>(){

            @Nullable
            public final Map<String, Object> invoke() {
                return params;
            }
        }), gson, client);
    }

    public /* synthetic */ Socket(String string, Map map, Gson gson, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            gson = Defaults.INSTANCE.getGson();
        }
        if ((n & 8) != 0) {
            OkHttpClient okHttpClient2 = new OkHttpClient.Builder().build();
            Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient2, (String)"OkHttpClient.Builder().build()");
            okHttpClient = okHttpClient2;
        }
        this(string, map, gson, okHttpClient);
    }

    public static final /* synthetic */ Gson access$getGson$p(Socket $this) {
        return $this.gson;
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(Socket $this) {
        return $this.client;
    }
}

