/*
 * Decompiled with CFR 0.152.
 */
package org.phoenixframework;

import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.phoenixframework.Transport;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010.\u001a\u00020\u0011H\u0016J\u001a\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00102\b\u00101\u001a\u0004\u0018\u00010\u001fH\u0016J \u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\t2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u001fH\u0016J \u00104\u001a\u00020\u00112\u0006\u00103\u001a\u00020\t2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u001fH\u0016J\"\u00105\u001a\u00020\u00112\u0006\u00103\u001a\u00020\t2\u0006\u00106\u001a\u00020\u00182\b\u00107\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u00103\u001a\u00020\t2\u0006\u00108\u001a\u00020\u001fH\u0016J\u0018\u0010\"\u001a\u00020\u00112\u0006\u00103\u001a\u00020\t2\u0006\u00107\u001a\u00020\u0019H\u0016J\u0010\u00109\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\u001fH\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R0\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/phoenixframework/WebSocketTransport;", "Lokhttp3/WebSocketListener;", "Lorg/phoenixframework/Transport;", "url", "Ljava/net/URL;", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Ljava/net/URL;Lokhttp3/OkHttpClient;)V", "connection", "Lokhttp3/WebSocket;", "getConnection$JavaPhoenixClient", "()Lokhttp3/WebSocket;", "setConnection$JavaPhoenixClient", "(Lokhttp3/WebSocket;)V", "onClose", "Lkotlin/Function1;", "", "", "getOnClose", "()Lkotlin/jvm/functions/Function1;", "setOnClose", "(Lkotlin/jvm/functions/Function1;)V", "onError", "Lkotlin/Function2;", "", "Lokhttp3/Response;", "getOnError", "()Lkotlin/jvm/functions/Function2;", "setOnError", "(Lkotlin/jvm/functions/Function2;)V", "onMessage", "", "getOnMessage", "setOnMessage", "onOpen", "Lkotlin/Function0;", "getOnOpen", "()Lkotlin/jvm/functions/Function0;", "setOnOpen", "(Lkotlin/jvm/functions/Function0;)V", "readyState", "Lorg/phoenixframework/Transport$ReadyState;", "getReadyState", "()Lorg/phoenixframework/Transport$ReadyState;", "setReadyState", "(Lorg/phoenixframework/Transport$ReadyState;)V", "connect", "disconnect", "code", "reason", "onClosed", "webSocket", "onClosing", "onFailure", "t", "response", "text", "send", "data", "JavaPhoenixClient"})
public final class WebSocketTransport
extends WebSocketListener
implements Transport {
    @Nullable
    private WebSocket connection;
    @NotNull
    private Transport.ReadyState readyState;
    @Nullable
    private Function0<Unit> onOpen;
    @Nullable
    private Function2<? super Throwable, ? super Response, Unit> onError;
    @Nullable
    private Function1<? super String, Unit> onMessage;
    @Nullable
    private Function1<? super Integer, Unit> onClose;
    private final URL url;
    private final OkHttpClient okHttpClient;

    @Nullable
    public final WebSocket getConnection$JavaPhoenixClient() {
        return this.connection;
    }

    public final void setConnection$JavaPhoenixClient(@Nullable WebSocket webSocket) {
        this.connection = webSocket;
    }

    @Override
    @NotNull
    public Transport.ReadyState getReadyState() {
        return this.readyState;
    }

    public void setReadyState(@NotNull Transport.ReadyState readyState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)readyState), (String)"<set-?>");
        this.readyState = readyState;
    }

    @Override
    @Nullable
    public Function0<Unit> getOnOpen() {
        return this.onOpen;
    }

    @Override
    public void setOnOpen(@Nullable Function0<Unit> function0) {
        this.onOpen = function0;
    }

    @Override
    @Nullable
    public Function2<Throwable, Response, Unit> getOnError() {
        return this.onError;
    }

    @Override
    public void setOnError(@Nullable Function2<? super Throwable, ? super Response, Unit> function2) {
        this.onError = function2;
    }

    @Override
    @Nullable
    public Function1<String, Unit> getOnMessage() {
        return this.onMessage;
    }

    @Override
    public void setOnMessage(@Nullable Function1<? super String, Unit> function1) {
        this.onMessage = function1;
    }

    @Override
    @Nullable
    public Function1<Integer, Unit> getOnClose() {
        return this.onClose;
    }

    @Override
    public void setOnClose(@Nullable Function1<? super Integer, Unit> function1) {
        this.onClose = function1;
    }

    @Override
    public void connect() {
        this.setReadyState(Transport.ReadyState.CONNECTING);
        Request request = new Request.Builder().url(this.url).build();
        this.connection = this.okHttpClient.newWebSocket(request, (WebSocketListener)this);
    }

    @Override
    public void disconnect(int code, @Nullable String reason) {
        WebSocket webSocket = this.connection;
        if (webSocket != null) {
            webSocket.close(code, reason);
        }
        this.connection = null;
    }

    @Override
    public void send(@NotNull String data) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            WebSocket webSocket = this.connection;
            if (webSocket == null) break block0;
            webSocket.send(data);
        }
    }

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            this.setReadyState(Transport.ReadyState.OPEN);
            Function0<Unit> function0 = this.getOnOpen();
            if (function0 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            this.setReadyState(Transport.ReadyState.CLOSED);
            Function2<Throwable, Response, Unit> function2 = this.getOnError();
            if (function2 != null) {
                Unit cfr_ignored_0 = (Unit)function2.invoke((Object)t, (Object)response);
            }
            Function1<Integer, Unit> function1 = this.getOnClose();
            if (function1 == null) break block1;
            Unit cfr_ignored_1 = (Unit)function1.invoke((Object)1006);
        }
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        this.setReadyState(Transport.ReadyState.CLOSING);
        webSocket.close(code, reason);
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Function1<String, Unit> function1 = this.getOnMessage();
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)text);
        }
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
            Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
            this.setReadyState(Transport.ReadyState.CLOSED);
            Function1<Integer, Unit> function1 = this.getOnClose();
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)code);
        }
    }

    public WebSocketTransport(@NotNull URL url, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        this.url = url;
        this.okHttpClient = okHttpClient;
        this.readyState = Transport.ReadyState.CLOSED;
    }
}

